/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher.formatter;

import apoc.export.cypher.formatter.CypherFormat;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.Reporter;
import apoc.util.Util;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintType;

abstract class AbstractCypherFormatter
implements CypherFormatter {
    private static final String STATEMENT_CONSTRAINTS = "CREATE CONSTRAINT %s%s FOR (node:%s) REQUIRE (%s) %s;";
    private static final String STATEMENT_CONSTRAINTS_REL = "CREATE CONSTRAINT %s%s FOR ()-[rel:%s]-() REQUIRE (%s) %s;";
    private static final String STATEMENT_DROP_CONSTRAINTS = "DROP CONSTRAINT %s;";
    private static final String STATEMENT_NODE_FULLTEXT_IDX = "CREATE FULLTEXT INDEX %s FOR (n:%s) ON EACH [%s];";
    private static final String STATEMENT_REL_FULLTEXT_IDX = "CREATE FULLTEXT INDEX %s FOR ()-[rel:%s]-() ON EACH [%s];";
    public static final String PROPERTY_QUOTING_FORMAT = "%s.`%s`";
    private static final String ID_REL_KEY = "id";

    AbstractCypherFormatter() {
    }

    @Override
    public String statementForCleanUpNodes(int batchSize) {
        return "MATCH (n:" + CypherFormatterUtils.Q_UNIQUE_ID_LABEL + ")  WITH n LIMIT " + batchSize + " REMOVE n:" + CypherFormatterUtils.Q_UNIQUE_ID_LABEL + " REMOVE n." + Util.quote("UNIQUE IMPORT ID") + ";";
    }

    @Override
    public String statementForCleanUpRelationships(int batchSize) {
        return "MATCH ()-[r]->() WHERE r." + CypherFormatterUtils.Q_UNIQUE_ID_REL + " IS NOT NULL WITH r LIMIT " + batchSize + " REMOVE r." + CypherFormatterUtils.Q_UNIQUE_ID_REL + ";";
    }

    @Override
    public String statementForNodeIndex(String indexType, String label, Iterable<String> keys, boolean ifNotExists, String idxName) {
        return String.format("CREATE %s INDEX%s%s FOR (n:%s) ON (%s);", indexType, idxName, this.getIfNotExists(ifNotExists), Util.quote(label), this.getPropertiesQuoted(keys, "n."));
    }

    @Override
    public String statementForIndexRelationship(String indexType, String type, Iterable<String> keys, boolean ifNotExists, String idxName) {
        return String.format("CREATE %s INDEX%s%s FOR ()-[rel:%s]-() ON (%s);", indexType, idxName, this.getIfNotExists(ifNotExists), Util.quote(type), this.getPropertiesQuoted(keys, "rel."));
    }

    @Override
    public String statementForNodeFullTextIndex(String name, Iterable<Label> labels, Iterable<String> keys) {
        String label = StreamSupport.stream(labels.spliterator(), false).map(Label::name).map(Util::quote).collect(Collectors.joining("|"));
        String key = StreamSupport.stream(keys.spliterator(), false).map(s -> String.format(PROPERTY_QUOTING_FORMAT, "n", s)).collect(Collectors.joining(","));
        return String.format(STATEMENT_NODE_FULLTEXT_IDX, name, label, key);
    }

    @Override
    public String statementForRelationshipFullTextIndex(String name, Iterable<RelationshipType> types, Iterable<String> keys) {
        String type = StreamSupport.stream(types.spliterator(), false).map(RelationshipType::name).map(Util::quote).collect(Collectors.joining("|"));
        String key = StreamSupport.stream(keys.spliterator(), false).map(s -> String.format(PROPERTY_QUOTING_FORMAT, "rel", s)).collect(Collectors.joining(","));
        return String.format(STATEMENT_REL_FULLTEXT_IDX, name, type, key);
    }

    @Override
    public String statementForCreateConstraint(String name, String label, Iterable<String> keys, ConstraintType type, boolean ifNotExists) {
        String keysString = "";
        String typeString = "";
        String statement = "";
        switch (type) {
            case UNIQUENESS: {
                keysString = "node.";
                typeString = "IS UNIQUE";
                statement = STATEMENT_CONSTRAINTS;
                break;
            }
            case NODE_KEY: {
                keysString = "node.";
                typeString = "IS NODE KEY";
                statement = STATEMENT_CONSTRAINTS;
                break;
            }
            case NODE_PROPERTY_EXISTENCE: {
                keysString = "node.";
                typeString = "IS NOT NULL";
                statement = STATEMENT_CONSTRAINTS;
                break;
            }
            case RELATIONSHIP_UNIQUENESS: {
                keysString = "rel.";
                typeString = "IS UNIQUE";
                statement = STATEMENT_CONSTRAINTS_REL;
                break;
            }
            case RELATIONSHIP_KEY: {
                keysString = "rel.";
                typeString = "IS NODE KEY";
                statement = STATEMENT_CONSTRAINTS_REL;
                break;
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE: {
                keysString = "rel.";
                typeString = "IS NOT NULL";
                statement = STATEMENT_CONSTRAINTS_REL;
            }
        }
        return String.format(statement, Util.quote(name), this.getIfNotExists(ifNotExists), Util.quote(label), this.getPropertiesQuoted(keys, keysString), typeString);
    }

    @Override
    public String statementForDropConstraint(String name) {
        return String.format(STATEMENT_DROP_CONSTRAINTS, Util.quote(name));
    }

    private String getIfNotExists(boolean ifNotExists) {
        return ifNotExists ? " IF NOT EXISTS" : "";
    }

    private String getPropertiesQuoted(Iterable<String> keys, String prefix) {
        String keysString = StreamSupport.stream(keys.spliterator(), false).map(key -> prefix + Util.quote(key)).collect(Collectors.joining(", "));
        return keysString;
    }

    protected String mergeStatementForNode(CypherFormat cypherFormat, Node node, Map<String, Set<String>> uniqueConstraints, Set<String> indexedProperties, Set<String> indexNames) {
        StringBuilder result = new StringBuilder(1000);
        result.append("MERGE ");
        result.append(CypherFormatterUtils.formatNodeLookup("n", node, uniqueConstraints, indexNames));
        String notUniqueProperties = CypherFormatterUtils.formatNotUniqueProperties("n", node, uniqueConstraints, indexedProperties, false);
        String notUniqueLabels = CypherFormatterUtils.formatNotUniqueLabels("n", node, uniqueConstraints);
        if (!notUniqueProperties.isEmpty() || !notUniqueLabels.isEmpty()) {
            result.append(cypherFormat.equals((Object)CypherFormat.ADD_STRUCTURE) ? " ON CREATE SET " : " SET ");
            result.append(notUniqueProperties);
            result.append(!"".equals(notUniqueProperties) && !"".equals(notUniqueLabels) ? ", " : "");
            result.append(notUniqueLabels);
        }
        result.append(";");
        return result.toString();
    }

    public String mergeStatementForRelationship(CypherFormat cypherFormat, Relationship relationship, Map<String, Set<String>> uniqueConstraints, Set<String> indexedProperties, ExportConfig exportConfig) {
        StringBuilder result = new StringBuilder(1000);
        result.append("MATCH ");
        Node startNode = relationship.getStartNode();
        result.append(CypherFormatterUtils.formatNodeLookup("n1", startNode, uniqueConstraints, indexedProperties));
        result.append(", ");
        Node endNode = relationship.getEndNode();
        result.append(CypherFormatterUtils.formatNodeLookup("n2", endNode, uniqueConstraints, indexedProperties));
        RelationshipType type = relationship.getType();
        boolean withMultiRels = exportConfig.isMultipleRelationshipsWithType() && !CypherFormatterUtils.isUniqueRelationship(relationship);
        String mergeUniqueKey = withMultiRels ? CypherFormatterUtils.simpleKeyValue(CypherFormatterUtils.Q_UNIQUE_ID_REL, relationship.getId()) : "";
        result.append(" MERGE (n1)-[r:" + Util.quote(type.name()) + mergeUniqueKey + "]->(n2)");
        if (relationship.getPropertyKeys().iterator().hasNext()) {
            result.append(cypherFormat.equals((Object)CypherFormat.UPDATE_STRUCTURE) ? " ON CREATE SET " : " SET ");
            result.append(CypherFormatterUtils.formatRelationshipProperties("r", relationship, false));
        }
        result.append(";");
        return result.toString();
    }

    public void buildStatementForNodes(String nodeClause, String setClause, Iterable<Node> nodes, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, Reporter reporter, GraphDatabaseService db) {
        boolean shouldContinue = true;
        AtomicInteger totalNodeCount = new AtomicInteger(0);
        while (shouldContinue) {
            AtomicInteger nodesInBatch = new AtomicInteger(0);
            Function<Node, Map.Entry> keyMapper = node -> {
                try (Transaction tx = db.beginTx();){
                    totalNodeCount.incrementAndGet();
                    nodesInBatch.incrementAndGet();
                    node = tx.getNodeByElementId(node.getElementId());
                    Set<String> idProperties = CypherFormatterUtils.getNodeIdProperties(node, uniqueConstraints).keySet();
                    Set<String> labels = this.getLabels((Node)node);
                    tx.commit();
                    AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>>(labels, idProperties);
                    return simpleImmutableEntry;
                }
            };
            Map groupedData = StreamSupport.stream(Iterables.limit((Iterable)Iterables.skip(nodes, (int)totalNodeCount.get()), (int)exportConfig.getBatchSize()).spliterator(), true).collect(Collectors.groupingByConcurrent(keyMapper));
            if (nodesInBatch.get() < exportConfig.getBatchSize()) {
                shouldContinue = false;
            }
            AtomicInteger propertiesCount = new AtomicInteger(0);
            AtomicInteger batchCount = new AtomicInteger(0);
            AtomicInteger nodeCount = new AtomicInteger(0);
            groupedData.forEach((key, nodeList) -> {
                AtomicInteger unwindCount = new AtomicInteger(0);
                int nodeListSize = nodeList.size();
                Node last = (Node)nodeList.get(nodeListSize - 1);
                nodeCount.addAndGet(nodeListSize);
                for (Node node : nodeList) {
                    this.writeBatchBegin(exportConfig, out, batchCount);
                    this.writeUnwindStart(exportConfig, out, unwindCount);
                    batchCount.incrementAndGet();
                    unwindCount.incrementAndGet();
                    Map props = node.getAllProperties();
                    out.append("{");
                    Map<String, Object> idMap = CypherFormatterUtils.getNodeIdProperties(node, uniqueConstraints);
                    this.writeNodeIds(out, idMap);
                    out.append(", ");
                    out.append("properties:");
                    propertiesCount.addAndGet(props.size());
                    props.keySet().removeAll(idMap.keySet());
                    this.writeProperties(out, props);
                    out.append("}");
                    if (last.equals((Object)node) || this.isBatchMatch(exportConfig, batchCount) || this.isUnwindBatchMatch(exportConfig, unwindCount)) {
                        this.closeUnwindNodes(nodeClause, setClause, uniqueConstraints, exportConfig, out, (Map.Entry<Set<String>, Set<String>>)key, last);
                        this.writeBatchEnd(exportConfig, out, batchCount);
                        unwindCount.set(0);
                        continue;
                    }
                    out.append(", ");
                }
            });
            this.addCommitToEnd(exportConfig, out, batchCount);
            reporter.update(nodeCount.get(), 0L, propertiesCount.longValue());
        }
    }

    private void closeUnwindNodes(String nodeClause, String setClause, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, Map.Entry<Set<String>, Set<String>> key, Node last) {
        this.writeUnwindEnd(exportConfig, out);
        out.append("\n");
        out.append(nodeClause);
        String label = this.getUniqueConstrainedLabel(last, uniqueConstraints);
        out.append("(n:");
        out.append(Util.quote(label));
        out.append("{");
        this.writeSetProperties(out, key.getValue());
        out.append("}) ");
        out.append(setClause);
        out.append("n += row.properties");
        String addLabels = key.getKey().stream().filter(l -> !l.equals(label)).map(Util::quote).collect(Collectors.joining(":"));
        if (!addLabels.isEmpty()) {
            out.append(" SET n:");
            out.append(addLabels);
        }
        out.append(";");
        out.append("\n");
    }

    private void writeSetProperties(PrintWriter out, Set<String> value) {
        this.writeSetProperties(out, value, null);
    }

    private void writeSetProperties(PrintWriter out, Set<String> value, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        int size = value.size();
        for (String s : value) {
            out.append(Util.quote(s) + ": row." + prefix + this.formatNodeId(s));
            if (--size <= 0) continue;
            out.append(", ");
        }
    }

    private boolean isBatchMatch(ExportConfig exportConfig, AtomicInteger batchCount) {
        return batchCount.get() % exportConfig.getBatchSize() == 0;
    }

    public void buildStatementForRelationships(String relationshipClause, String setClause, Iterable<Relationship> relationship, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, Reporter reporter, GraphDatabaseService db) {
        boolean shouldContinue = true;
        AtomicInteger totalRelCount = new AtomicInteger(0);
        while (shouldContinue) {
            AtomicInteger relsInBatch = new AtomicInteger(0);
            Function<Relationship, Map> keyMapper = rel -> {
                totalRelCount.incrementAndGet();
                relsInBatch.incrementAndGet();
                try (Transaction tx = db.beginTx();){
                    rel = tx.getRelationshipByElementId(rel.getElementId());
                    Node start = rel.getStartNode();
                    Set<String> startLabels = this.getLabels(start);
                    Node end = rel.getEndNode();
                    Set<String> endLabels = this.getLabels(end);
                    String type = rel.getType().name();
                    Map<String, Object> key = Util.map("type", type, "start", new AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>>(startLabels, CypherFormatterUtils.getNodeIdProperties(start, uniqueConstraints).keySet()), "end", new AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>>(endLabels, CypherFormatterUtils.getNodeIdProperties(end, uniqueConstraints).keySet()));
                    tx.commit();
                    Map<String, Object> map = key;
                    return map;
                }
            };
            Map groupedData = StreamSupport.stream(Iterables.limit((Iterable)Iterables.skip(relationship, (int)totalRelCount.get()), (int)exportConfig.getBatchSize()).spliterator(), true).collect(Collectors.groupingByConcurrent(keyMapper));
            if (relsInBatch.get() < exportConfig.getBatchSize()) {
                shouldContinue = false;
            }
            AtomicInteger propertiesCount = new AtomicInteger(0);
            AtomicInteger batchCount = new AtomicInteger(0);
            String start = "start";
            String end = "end";
            AtomicInteger relCount = new AtomicInteger(0);
            groupedData.forEach((path, relationshipList) -> {
                AtomicInteger unwindCount = new AtomicInteger(0);
                int relSize = relationshipList.size();
                relCount.addAndGet(relSize);
                Relationship last = (Relationship)relationshipList.get(relSize - 1);
                for (Relationship rel : relationshipList) {
                    this.writeBatchBegin(exportConfig, out, batchCount);
                    this.writeUnwindStart(exportConfig, out, unwindCount);
                    batchCount.incrementAndGet();
                    unwindCount.incrementAndGet();
                    Map props = rel.getAllProperties();
                    out.append("{");
                    Node startNode = rel.getStartNode();
                    this.writeRelationshipNodeIds(uniqueConstraints, out, start, startNode);
                    Node endNode = rel.getEndNode();
                    boolean withMultipleRels = exportConfig.isMultipleRelationshipsWithType();
                    out.append(", ");
                    if (withMultipleRels) {
                        String uniqueId = String.format("%s: %s, ", ID_REL_KEY, rel.getId());
                        out.append(uniqueId);
                    }
                    this.writeRelationshipNodeIds(uniqueConstraints, out, end, endNode);
                    out.append(", ");
                    out.append("properties:");
                    this.writeProperties(out, props);
                    propertiesCount.addAndGet(props.size());
                    out.append("}");
                    if (last.equals((Object)rel) || this.isBatchMatch(exportConfig, batchCount) || this.isUnwindBatchMatch(exportConfig, unwindCount)) {
                        this.closeUnwindRelationships(relationshipClause, setClause, uniqueConstraints, exportConfig, out, start, end, (Map<String, Object>)path, last, withMultipleRels);
                        this.writeBatchEnd(exportConfig, out, batchCount);
                        unwindCount.set(0);
                        continue;
                    }
                    out.append(", ");
                }
            });
            this.addCommitToEnd(exportConfig, out, batchCount);
            reporter.update(0L, relCount.get(), propertiesCount.longValue());
        }
    }

    private void closeUnwindRelationships(String relationshipClause, String setClause, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, String start, String end, Map<String, Object> path, Relationship last, boolean withMultipleRels) {
        this.writeUnwindEnd(exportConfig, out);
        this.writeRelationshipMatchAsciiNode(last.getStartNode(), out, start, uniqueConstraints);
        this.writeRelationshipMatchAsciiNode(last.getEndNode(), out, end, uniqueConstraints);
        out.append("\n");
        out.append(relationshipClause);
        String mergeUniqueKey = withMultipleRels ? CypherFormatterUtils.simpleKeyValue(CypherFormatterUtils.Q_UNIQUE_ID_REL, "row.id") : "";
        out.append("(start)-[r:" + Util.quote(path.get("type").toString()) + mergeUniqueKey + "]->(end) ");
        out.append(setClause);
        out.append("r += row.properties;");
        out.append("\n");
    }

    private boolean isUnwindBatchMatch(ExportConfig exportConfig, AtomicInteger batchCount) {
        return batchCount.get() % exportConfig.getUnwindBatchSize() == 0;
    }

    private void writeBatchEnd(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (this.isBatchMatch(exportConfig, batchCount)) {
            out.append(exportConfig.getFormat().commit());
        }
    }

    public void writeProperties(PrintWriter out, Map<String, Object> props) {
        out.append("{");
        if (!props.isEmpty()) {
            int size = props.size();
            for (Map.Entry<String, Object> es : props.entrySet()) {
                --size;
                out.append(Util.quote(es.getKey()));
                out.append(":");
                out.append(CypherFormatterUtils.toString(es.getValue()));
                if (size <= 0) continue;
                out.append(", ");
            }
        }
        out.append("}");
    }

    private String formatNodeId(String key) {
        if ("UNIQUE IMPORT ID".equals(key)) {
            key = "_id";
        }
        return Util.quote(key);
    }

    private void addCommitToEnd(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (batchCount.get() % exportConfig.getBatchSize() != 0) {
            out.append(exportConfig.getFormat().commit());
        }
    }

    private void writeBatchBegin(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (this.isBatchMatch(exportConfig, batchCount)) {
            out.append(exportConfig.getFormat().begin());
        }
    }

    private void writeUnwindStart(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (this.isUnwindBatchMatch(exportConfig, batchCount)) {
            String start = exportConfig.getFormat() == ExportFormat.CYPHER_SHELL && exportConfig.getOptimizationType() == ExportConfig.OptimizationType.UNWIND_BATCH_PARAMS ? ":param rows => [" : "UNWIND [";
            out.append(start);
        }
    }

    private void writeUnwindEnd(ExportConfig exportConfig, PrintWriter out) {
        out.append("]");
        if (exportConfig.getFormat() == ExportFormat.CYPHER_SHELL && exportConfig.getOptimizationType() == ExportConfig.OptimizationType.UNWIND_BATCH_PARAMS) {
            out.append("\n");
            out.append("UNWIND $rows");
        }
        out.append(" AS row");
    }

    private String getUniqueConstrainedLabel(Node node, Map<String, Set<String>> uniqueConstraints) {
        return uniqueConstraints.entrySet().stream().filter(e -> node.hasLabel(Label.label((String)((String)e.getKey()))) && ((Set)e.getValue()).stream().allMatch(k -> node.hasProperty(k))).map(e -> (String)e.getKey()).findFirst().orElse("UNIQUE IMPORT LABEL");
    }

    private Set<String> getUniqueConstrainedProperties(Map<String, Set<String>> uniqueConstraints, String uniqueConstrainedLabel) {
        Set<String> props = uniqueConstraints.get(uniqueConstrainedLabel);
        if (props == null || props.isEmpty()) {
            props = Collections.singleton("UNIQUE IMPORT ID");
        }
        return props;
    }

    private Set<String> getLabels(Node node) {
        Set<String> labels = StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toSet());
        if (labels.isEmpty()) {
            labels.add("UNIQUE IMPORT LABEL");
        }
        return labels;
    }

    private void writeRelationshipMatchAsciiNode(Node node, PrintWriter out, String key, Map<String, Set<String>> uniqueConstraints) {
        String uniqueConstrainedLabel = this.getUniqueConstrainedLabel(node, uniqueConstraints);
        Set<String> uniqueConstrainedProps = this.getUniqueConstrainedProperties(uniqueConstraints, uniqueConstrainedLabel);
        out.append("\n");
        out.append("MATCH ");
        out.append("(");
        out.append(key);
        out.append(":");
        out.append(Util.quote(uniqueConstrainedLabel));
        out.append("{");
        this.writeSetProperties(out, uniqueConstrainedProps, key + ".");
        out.append("})");
    }

    private void writeRelationshipNodeIds(Map<String, Set<String>> uniqueConstraints, PrintWriter out, String key, Node node) {
        Map<String, Object> properties;
        String uniqueConstrainedLabel = this.getUniqueConstrainedLabel(node, uniqueConstraints);
        Set<String> props = this.getUniqueConstrainedProperties(uniqueConstraints, uniqueConstrainedLabel);
        if (!props.contains("UNIQUE IMPORT ID")) {
            String[] propsArray = props.toArray(new String[props.size()]);
            properties = node.getProperties(propsArray);
        } else {
            properties = Util.map("UNIQUE IMPORT ID", node.getId());
        }
        out.append(key + ": ");
        out.append("{");
        this.writeNodeIds(out, properties);
        out.append("}");
    }

    private void writeNodeIds(PrintWriter out, Map<String, Object> properties) {
        int size = properties.size();
        for (Map.Entry<String, Object> es : properties.entrySet()) {
            --size;
            out.append(this.formatNodeId(es.getKey()));
            out.append(":");
            out.append(CypherFormatterUtils.toString(es.getValue()));
            if (size <= 0) continue;
            out.append(", ");
        }
    }
}

