/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.graphml;

import apoc.export.graphml.XmlNodeExport;
import apoc.export.util.BatchTransaction;
import apoc.export.util.ExportConfig;
import apoc.export.util.Reporter;
import apoc.util.JsonUtil;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.TerminationGuard;

public class XmlGraphMLReader {
    public static final String LABEL_SPLIT = " *: *";
    private final GraphDatabaseService db;
    private boolean storeNodeIds;
    private RelationshipType defaultRelType = RelationshipType.withName((String)"UNKNOWN");
    private ExportConfig.NodeConfig source;
    private ExportConfig.NodeConfig target;
    private int batchSize = 40000;
    private Reporter reporter;
    private boolean labels;
    public static final QName ID = QName.valueOf("id");
    public static final QName LABELS = QName.valueOf("labels");
    public static final QName LABEL = QName.valueOf("label");
    public static final QName FOR = QName.valueOf("for");
    public static final QName NAME = QName.valueOf("attr.name");
    public static final QName TYPE = QName.valueOf("attr.type");
    public static final QName LIST = QName.valueOf("attr.list");
    public static final QName KEY = QName.valueOf("key");

    public XmlGraphMLReader storeNodeIds() {
        this.storeNodeIds = true;
        return this;
    }

    public XmlGraphMLReader relType(String name) {
        this.defaultRelType = RelationshipType.withName((String)name);
        return this;
    }

    public XmlGraphMLReader batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public XmlGraphMLReader nodeLabels(boolean readLabels) {
        this.labels = readLabels;
        return this;
    }

    public XmlGraphMLReader source(ExportConfig.NodeConfig sourceConfig) {
        this.source = sourceConfig;
        return this;
    }

    public XmlGraphMLReader target(ExportConfig.NodeConfig targetConfig) {
        this.target = targetConfig;
        return this;
    }

    public XmlGraphMLReader reporter(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public ExportConfig.NodeConfig getSource() {
        return this.source;
    }

    public ExportConfig.NodeConfig getTarget() {
        return this.target;
    }

    public XmlGraphMLReader(GraphDatabaseService db) {
        this.db = db;
    }

    public long parseXML(Reader input, TerminationGuard terminationGuard) throws XMLStreamException {
        HashMap<String, String> cache = new HashMap<String, String>(32768);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XMLEventReader reader = inputFactory.createXMLEventReader(input);
        Node last = null;
        HashMap<String, Key> nodeKeys = new HashMap<String, Key>();
        HashMap<String, Key> relKeys = new HashMap<String, Key>();
        int count = 0;
        BatchTransaction tx = new BatchTransaction(this.db, this.batchSize * 10, this.reporter);
        try {
            while (reader.hasNext()) {
                String id;
                StartElement element;
                String name;
                XMLEvent event;
                terminationGuard.check();
                try {
                    event = (XMLEvent)reader.next();
                    if (event.getEventType() == 11) {
                        this.generateXmlDoctypeException();
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Unexpected EOF")) break;
                    if (!e.getMessage().contains("DOCTYPE")) continue;
                    throw e;
                }
                if (!event.isStartElement() || (name = (element = event.asStartElement()).getName().getLocalPart()).equals("graphml") || name.equals("graph")) continue;
                if (name.equals("key")) {
                    id = this.getAttribute(element, ID);
                    Key key = new Key(this.getAttribute(element, NAME), this.getAttribute(element, TYPE), this.getAttribute(element, LIST), this.getAttribute(element, FOR));
                    XMLEvent next = this.peek(reader);
                    if (next.isStartElement() && next.asStartElement().getName().getLocalPart().equals("default")) {
                        reader.nextEvent().asStartElement();
                        XMLEvent nextEvent = reader.nextEvent();
                        if (nextEvent.isCharacters()) {
                            key.setDefault(reader.nextEvent().asCharacters().getData());
                        }
                    }
                    if (key.forNode) {
                        nodeKeys.put(id, key);
                        continue;
                    }
                    relKeys.put(id, key);
                    continue;
                }
                if (name.equals("data")) {
                    Key key;
                    if (last == null) continue;
                    id = this.getAttribute(element, KEY);
                    boolean isNode = last instanceof Node;
                    Key key2 = key = isNode ? (Key)nodeKeys.get(id) : (Key)relKeys.get(id);
                    if (key == null) {
                        key = Key.defaultKey(id, isNode);
                    }
                    Map.Entry<XMLEvent, Object> eventEntry = this.getDataEventEntry(reader, key);
                    XMLEvent next = eventEntry.getKey();
                    Object value = eventEntry.getValue();
                    if (value != null) {
                        if (this.labels && isNode && id.equals("labels")) {
                            this.addLabels(last, value.toString());
                            continue;
                        }
                        if (this.labels && !isNode && id.equals("label")) continue;
                        last.setProperty(key.nameOrId, value);
                        if (this.reporter == null) continue;
                        this.reporter.update(0L, 0L, 1L);
                        continue;
                    }
                    if (next.getEventType() != 2) continue;
                    last.setProperty(key.nameOrId, (Object)"");
                    this.reporter.update(0L, 0L, 1L);
                    continue;
                }
                if (name.equals("node")) {
                    tx.increment();
                    id = this.getAttribute(element, ID);
                    Node node = tx.getTransaction().createNode();
                    if (this.labels) {
                        String labels = this.getAttribute(element, LABELS);
                        this.addLabels(node, labels);
                    }
                    if (this.storeNodeIds) {
                        node.setProperty("id", (Object)id);
                    }
                    this.setDefaults(nodeKeys, (Entity)node);
                    last = node;
                    cache.put(id, node.getElementId());
                    if (this.reporter != null) {
                        this.reporter.update(1L, 0L, 0L);
                    }
                    ++count;
                    continue;
                }
                if (!name.equals("edge")) continue;
                tx.increment();
                String label = this.getAttribute(element, LABEL);
                Node from = this.getByNodeId(cache, tx.getTransaction(), element, XmlNodeExport.NodeType.SOURCE);
                Node to = this.getByNodeId(cache, tx.getTransaction(), element, XmlNodeExport.NodeType.TARGET);
                RelationshipType relationshipType = label == null ? this.getRelationshipType(reader) : RelationshipType.withName((String)label);
                Relationship relationship = from.createRelationshipTo(to, relationshipType);
                this.setDefaults(relKeys, (Entity)relationship);
                last = relationship;
                if (this.reporter != null) {
                    this.reporter.update(0L, 1L, 0L);
                }
                ++count;
            }
            tx.doCommit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            tx.close();
            reader.close();
        }
        return count;
    }

    private Map.Entry<XMLEvent, Object> getDataEventEntry(XMLEventReader reader, Key key) {
        Object value = key.defaultValue;
        Map.Entry<XMLEvent, String> peekEntry = this.peekRecursively(reader, null);
        if (peekEntry.getValue() != null) {
            value = key.parseValue(peekEntry.getValue());
        }
        return new AbstractMap.SimpleEntry<XMLEvent, Object>(peekEntry.getKey(), value);
    }

    private Map.Entry<XMLEvent, String> peekRecursively(XMLEventReader reader, String data) {
        try {
            XMLEvent peek = this.peek(reader);
            if (peek.isCharacters()) {
                data = StringUtils.join(data, reader.nextEvent().asCharacters().getData());
                return this.peekRecursively(reader, data);
            }
            return new AbstractMap.SimpleEntry<XMLEvent, String>(peek, data);
        }
        catch (Exception e) {
            return this.peekRecursively(reader, data);
        }
    }

    private Node getByNodeId(Map<String, String> cache, Transaction tx, StartElement element, XmlNodeExport.NodeType nodeType) {
        XmlNodeExport.ExportNode xmlNodeInterface = nodeType.get();
        ExportConfig.NodeConfig nodeConfig = xmlNodeInterface.getNodeConfigReader(this);
        String sourceTargetValue = this.getAttribute(element, QName.valueOf(nodeType.getName()));
        String id = cache.get(sourceTargetValue);
        if (StringUtils.isBlank(nodeConfig.label)) {
            if (id == null) {
                throw new RuntimeException("The node with the given id: " + sourceTargetValue + " was not found. Check that it is defined before the referencing relationship.");
            }
            return tx.getNodeByElementId(id);
        }
        String attribute = this.getAttribute(element, QName.valueOf(nodeType.getNameType()));
        String value = attribute == null ? sourceTargetValue : Type.forType(attribute).parse(sourceTargetValue);
        return tx.findNode(Label.label((String)nodeConfig.label), Optional.ofNullable(nodeConfig.id).orElse("id"), (Object)value);
    }

    private RelationshipType getRelationshipType(XMLEventReader reader) throws XMLStreamException {
        if (this.labels) {
            boolean notStartElementOrContainsKeyLabel;
            XMLEvent peek = reader.peek();
            boolean isChar = peek.isCharacters();
            if (isChar && !peek.asCharacters().isWhiteSpace()) {
                String el;
                String value = peek.asCharacters().getData();
                String typeRel = value.contains(el = ":") ? value.replace(el, "") : value;
                return RelationshipType.withName((String)typeRel.trim());
            }
            boolean bl = notStartElementOrContainsKeyLabel = isChar || !peek.isStartElement() || this.containsLabelKey(peek);
            if (!peek.isEndDocument() && notStartElementOrContainsKeyLabel) {
                reader.nextEvent();
                return this.getRelationshipType(reader);
            }
        }
        reader.nextEvent();
        return this.defaultRelType;
    }

    private boolean containsLabelKey(XMLEvent peek) {
        Attribute keyAttribute = peek.asStartElement().getAttributeByName(new QName("key"));
        return keyAttribute != null && keyAttribute.getValue().equals("label");
    }

    private void addLabels(Node node, String labels) {
        String[] parts;
        if (labels == null) {
            return;
        }
        if ((labels = labels.trim()).isEmpty()) {
            return;
        }
        for (String part : parts = labels.split(LABEL_SPLIT)) {
            if (part.trim().isEmpty()) continue;
            node.addLabel(Label.label((String)part.trim()));
        }
    }

    private XMLEvent peek(XMLEventReader reader) throws XMLStreamException {
        XMLEvent peek = reader.peek();
        if (peek.isCharacters() && peek.asCharacters().isWhiteSpace()) {
            reader.nextEvent();
            return this.peek(reader);
        }
        return peek;
    }

    private void setDefaults(Map<String, Key> keys, Entity pc) {
        if (keys.isEmpty()) {
            return;
        }
        for (Key key : keys.values()) {
            if (key.defaultValue == null) continue;
            pc.setProperty(key.nameOrId, key.defaultValue);
        }
    }

    private String getAttribute(StartElement element, QName qname) {
        Attribute attribute = element.getAttributeByName(qname);
        return attribute != null ? attribute.getValue() : null;
    }

    private RuntimeException generateXmlDoctypeException() {
        throw new RuntimeException("XML documents with a DOCTYPE are not allowed.");
    }

    static class Key {
        String nameOrId;
        boolean forNode;
        Type listType;
        Type type;
        Object defaultValue;

        public Key(String nameOrId, String type, String listType, String forNode) {
            this.nameOrId = nameOrId;
            this.type = Type.forType(type);
            if (listType != null) {
                this.listType = Type.forType(listType);
            }
            this.forNode = forNode == null || forNode.equalsIgnoreCase("node");
        }

        private static Key defaultKey(String id, boolean forNode) {
            return new Key(id, "string", null, forNode ? "node" : "edge");
        }

        public void setDefault(String data) {
            this.defaultValue = this.type.parse(data);
        }

        public Object parseValue(String input) {
            if (input == null || input.trim().isEmpty()) {
                return this.defaultValue;
            }
            if (this.listType != null) {
                return this.listType.parseList(input);
            }
            return this.type.parse(input);
        }
    }

    static enum Type {
        BOOLEAN{

            @Override
            Object parse(String value) {
                return Boolean.valueOf(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Boolean.class, i -> (Boolean)i);
            }
        }
        ,
        INT{

            @Override
            Object parse(String value) {
                if (value.equalsIgnoreCase("NAN")) {
                    return Float.valueOf(Float.NaN);
                }
                return Integer.parseInt(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Integer.class, n -> ((Number)n).intValue());
            }
        }
        ,
        LONG{

            @Override
            Object parse(String value) {
                if (value.equalsIgnoreCase("NAN")) {
                    return Float.valueOf(Float.NaN);
                }
                return Long.parseLong(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Long.class, i -> ((Number)i).longValue());
            }
        }
        ,
        FLOAT{

            @Override
            Object parse(String value) {
                if (value.equalsIgnoreCase("NAN")) {
                    return Float.valueOf(Float.NaN);
                }
                return Float.valueOf(Float.parseFloat(value));
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Float.class, i -> Float.valueOf(((Number)i).floatValue()));
            }
        }
        ,
        DOUBLE{

            @Override
            Object parse(String value) {
                if (value.equalsIgnoreCase("NAN")) {
                    return Double.NaN;
                }
                return Double.parseDouble(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Double.class, i -> ((Number)i).doubleValue());
            }
        }
        ,
        STRING{

            @Override
            Object parse(String value) {
                return value;
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, String.class, i -> (String)i);
            }
        };


        abstract Object parse(String var1);

        abstract Object parseList(String var1);

        public static <T> T[] parseList(String value, Class<T> asClass, Function<Object, T> convert) {
            List parsed = JsonUtil.parse(value, null, List.class);
            Object[] converted = (Object[])Array.newInstance(asClass, parsed.size());
            for (int i = 0; i < parsed.size(); ++i) {
                converted[i] = convert.apply(parsed.get(i));
            }
            return converted;
        }

        public static Type forType(String type) {
            if (type == null) {
                return STRING;
            }
            return Type.valueOf(type.trim().toUpperCase());
        }
    }
}

