/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.cypher.ExportFileManager;
import apoc.export.util.ExportConfig;
import apoc.export.util.ProgressReporter;
import apoc.result.ExportProgressInfo;
import apoc.util.QueueBasedSpliterator;
import apoc.util.QueueUtil;
import apoc.util.Util;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.TerminationGuard;

public class ExportUtils {
    private ExportUtils() {
    }

    public static Stream<ExportProgressInfo> getProgressInfoStream(GraphDatabaseService db, ExecutorService executorService, TerminationGuard terminationGuard, String format, ExportConfig exportConfig, ProgressReporter reporter, ExportFileManager cypherFileManager, BiConsumer<Transaction, ProgressReporter> dump) {
        long timeout = exportConfig.getTimeoutSeconds();
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1000);
        ProgressReporter reporterWithConsumer = reporter.withConsumer(pi -> QueueUtil.put(queue, pi == ExportProgressInfo.EMPTY ? ExportProgressInfo.EMPTY : new ExportProgressInfo((ExportProgressInfo)pi).drain(cypherFileManager.getStringWriter(format), exportConfig), timeout));
        Util.inTxFuture(null, executorService, db, threadBoundTx -> {
            dump.accept((Transaction)threadBoundTx, reporterWithConsumer);
            return true;
        }, 0L, _ignored -> {}, _ignored -> QueueUtil.put(queue, ExportProgressInfo.EMPTY, timeout));
        QueueBasedSpliterator<ExportProgressInfo> spliterator = new QueueBasedSpliterator<ExportProgressInfo>(queue, ExportProgressInfo.EMPTY, terminationGuard, (int)timeout);
        return StreamSupport.stream(spliterator, false);
    }
}

