/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.ExportConfig;
import apoc.export.util.FormatUtils;
import apoc.gephi.GephiFormatUtils;
import apoc.meta.Types;
import apoc.meta.tablesforlabels.PropertyTracker;
import apoc.util.MapUtil;
import apoc.util.collection.Iterables;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResultTransformer;

public class MetaInformation {
    private static final Map<String, String> REVERSED_TYPE_MAP = MapUtil.invertMap(PropertyTracker.typeMappings);
    public static final Set<String> GRAPHML_ALLOWED = new HashSet<String>(Arrays.asList("boolean", "int", "long", "float", "double", "string"));

    public static Map<String, Class> collectPropTypesForNodes(SubGraph graph, GraphDatabaseService db, ExportConfig config) {
        if (!config.isSampling()) {
            LinkedHashMap<String, Class> propTypes = new LinkedHashMap<String, Class>();
            for (Node node : graph.getNodes()) {
                MetaInformation.updateKeyTypes(propTypes, (Entity)node);
            }
            return propTypes;
        }
        Map<String, Object> conf = config.getSamplingConfig();
        conf.putIfAbsent("includeLabels", Iterables.stream(graph.getAllLabelsInUse()).map(Label::name).collect(Collectors.toList()));
        return (Map)db.executeTransactionally("CALL apoc.meta.nodeTypeProperties($conf)", Map.of("conf", conf), MetaInformation.getMapResultTransformer());
    }

    public static Map<String, Class> collectPropTypesForRelationships(SubGraph graph, GraphDatabaseService db, ExportConfig config) {
        if (!config.isSampling()) {
            LinkedHashMap<String, Class> propTypes = new LinkedHashMap<String, Class>();
            for (Relationship relationship : graph.getRelationships()) {
                MetaInformation.updateKeyTypes(propTypes, (Entity)relationship);
            }
            return propTypes;
        }
        Map<String, Object> conf = config.getSamplingConfig();
        conf.putIfAbsent("includeRels", Iterables.stream(graph.getAllRelationshipTypesInUse()).map(RelationshipType::name).collect(Collectors.toList()));
        return (Map)db.executeTransactionally("CALL apoc.meta.relTypeProperties($conf)", Map.of("conf", conf), MetaInformation.getMapResultTransformer());
    }

    private static ResultTransformer<Map<String, Class>> getMapResultTransformer() {
        return result -> result.stream().filter(map -> map.get("propertyName") != null).collect(Collectors.toMap(map -> (String)map.get("propertyName"), map -> {
            String propertyTypes = (String)((List)map.get("propertyTypes")).get(0);
            String className = REVERSED_TYPE_MAP.get(propertyTypes);
            try {
                return ClassUtils.getClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, (e1, e2) -> e2));
    }

    public static void updateKeyTypes(Map<String, Class> keyTypes, Entity pc) {
        for (String prop : pc.getPropertyKeys()) {
            Object value = pc.getProperty(prop);
            Class storedClass = keyTypes.get(prop);
            if (storedClass == null) {
                keyTypes.put(prop, value.getClass());
                continue;
            }
            if (storedClass == Void.TYPE || storedClass.equals(value.getClass())) continue;
            keyTypes.put(prop, Void.TYPE);
        }
    }

    public static String typeFor(Class value, Set<String> allowed) {
        if (value == Void.TYPE) {
            return null;
        }
        Types type = Types.of(value);
        String name = (value.isArray() ? value.getComponentType() : value).getSimpleName().toLowerCase();
        boolean isAllowed = allowed != null && allowed.contains(name);
        switch (type) {
            case NULL: {
                return null;
            }
            case INTEGER: {
                return "integer".equals(name) || !isAllowed ? "int" : name;
            }
            case FLOAT: {
                return !isAllowed ? "float" : name;
            }
        }
        return isAllowed ? name : "string";
    }

    public static String getLabelsString(Node node) {
        if (!node.getLabels().iterator().hasNext()) {
            return "";
        }
        String delimiter = ":";
        return delimiter + FormatUtils.joinLabels(node, delimiter);
    }

    public static String getLabelsStringGephi(ExportConfig config, Node node) {
        return GephiFormatUtils.getCaption(node, config.getCaption());
    }
}

