/*
 * Decompiled with CFR 0.152.
 */
package apoc.lock;

import java.util.List;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class Lock {
    @Context
    public Transaction tx;

    @NotThreadSafe
    @Procedure(name="apoc.lock.all", mode=Mode.WRITE)
    @Description(value="Acquires a write lock on the given `NODE` and `RELATIONSHIP` values.")
    public void all(@Name(value="nodes", description="The list of nodes to acquire a write lock on.") List<Node> nodes, @Name(value="rels", description="The list of relationships to acquire a write lock on.") List<Relationship> rels) {
        for (Node node : nodes) {
            this.tx.acquireWriteLock((Entity)node);
        }
        for (Relationship rel : rels) {
            this.tx.acquireWriteLock((Entity)rel);
        }
    }

    @NotThreadSafe
    @Procedure(name="apoc.lock.nodes", mode=Mode.WRITE)
    @Description(value="Acquires a write lock on the given `NODE` values.")
    public void nodes(@Name(value="nodes", description="The list of nodes to acquire a write lock on.") List<Node> nodes) {
        for (Node node : nodes) {
            this.tx.acquireWriteLock((Entity)node);
        }
    }

    @NotThreadSafe
    @Procedure(name="apoc.lock.read.nodes", mode=Mode.READ)
    @Description(value="Acquires a read lock on the given `NODE` values.")
    public void readLockOnNodes(@Name(value="nodes", description="The list of nodes to acquire a read lock on.") List<Node> nodes) {
        for (Node node : nodes) {
            this.tx.acquireReadLock((Entity)node);
        }
    }

    @NotThreadSafe
    @Procedure(name="apoc.lock.rels", mode=Mode.WRITE)
    @Description(value="Acquires a write lock on the given `RELATIONSHIP` values.")
    public void rels(@Name(value="rels", description="The list of relationships to acquire a write lock on.") List<Relationship> rels) {
        for (Relationship rel : rels) {
            this.tx.acquireWriteLock((Entity)rel);
        }
    }

    @NotThreadSafe
    @Procedure(name="apoc.lock.read.rels", mode=Mode.READ)
    @Description(value="Acquires a read lock on the given `RELATIONSHIP` values.")
    public void readLocksOnRels(@Name(value="rels", description="The list of relationships to acquire a read lock on.") List<Relationship> rels) {
        for (Relationship rel : rels) {
            this.tx.acquireReadLock((Entity)rel);
        }
    }
}

