/*
 * Decompiled with CFR 0.152.
 */
package apoc.map;

import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Maps {
    @Context
    public Transaction tx;

    @UserFunction(value="apoc.map.groupBy")
    @Description(value="Creates a `MAP` of the `LIST<ANY>` keyed by the given property, with single values.")
    public Map<String, Object> groupBy(@Name(value="values", description="A list of map values to be grouped.") List<Object> values, @Name(value="key", description="The key to group the map values by.") String key) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(values.size());
        for (Object value : values) {
            Object id = this.getKey(key, value);
            if (id == null) continue;
            result.put(id.toString(), value);
        }
        return result;
    }

    @UserFunction(value="apoc.map.groupByMulti")
    @Description(value="Creates a `MAP` of the `LIST<ANY>` values keyed by the given property, with the `LIST<ANY>` values.")
    public Map<String, List<Object>> groupByMulti(@Name(value="values", description="A list of map values to be grouped.") List<Object> values, @Name(value="key", description="The key to group the map values by.") String key) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>(values.size());
        for (Object value : values) {
            Object id = this.getKey(key, value);
            if (id == null) continue;
            result.compute(id.toString(), (k, list) -> {
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(value);
                return list;
            });
        }
        return result;
    }

    public Object getKey(@Name(value="key") String key, Object value) {
        Object id = null;
        if (value instanceof Map) {
            id = ((Map)value).get(key);
        }
        if (value instanceof Entity) {
            id = ((Entity)value).getProperty(key, null);
        }
        return id;
    }

    @UserFunction(value="apoc.map.fromNodes")
    @Description(value="Returns a `MAP` of the given prop to the node of the given label.")
    public Map<String, Node> fromNodes(@Name(value="label", description="The node labels from which the map will be created.") String label, @Name(value="prop", description="The property name to map the returned nodes by.") String property) {
        LinkedHashMap<String, Node> result = new LinkedHashMap<String, Node>(10000);
        try (ResourceIterator nodes = this.tx.findNodes(Label.label((String)label));){
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                Object key = node.getProperty(property, null);
                if (key == null) continue;
                result.put(key.toString(), node);
            }
        }
        return result;
    }

    @UserFunction(value="apoc.map.fromPairs")
    @Description(value="Creates a `MAP` from the given `LIST<LIST<ANY>>` of key-value pairs.")
    public Map<String, Object> fromPairs(@Name(value="pairs", description="A list of pairs to create a map from.") List<List<Object>> pairs) {
        return Util.mapFromPairs(pairs);
    }

    @UserFunction(value="apoc.map.fromLists")
    @Description(value="Creates a `MAP` from the keys and values in the given `LIST<ANY>` values.")
    public Map<String, Object> fromLists(@Name(value="keys", description="A list of keys to create a map from.") List<String> keys, @Name(value="values", description="A list of values associated with the keys to create a map from.") List<Object> values) {
        return Util.mapFromLists(keys, values);
    }

    @UserFunction(value="apoc.map.values")
    @Description(value="Returns a `LIST<ANY>` indicated by the given keys (returns a null value if a given key is missing).")
    public List<Object> values(@Name(value="map", description="A map to extract values from.") Map<String, Object> map, @Name(value="keys", defaultValue="[]", description="A list of keys to extract from the given map.") List<String> keys, @Name(value="addNullsForMissing", defaultValue="false", description="Whether or not to return missing values as null values.") boolean addNullsForMissing) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (String key : keys) {
            if (!addNullsForMissing && !map.containsKey(key)) continue;
            values.add(map.get(key));
        }
        return values;
    }

    @UserFunction(value="apoc.map.fromValues")
    @Description(value="Creates a `MAP` from the alternating keys and values in the given `LIST<ANY>`.")
    public Map<String, Object> fromValues(@Name(value="values", description="A list of keys and values listed pairwise to create a map from.") List<Object> values) {
        return Util.map(values);
    }

    @UserFunction(value="apoc.map.merge")
    @Description(value="Merges the two given `MAP` values into one `MAP`.")
    public Map<String, Object> merge(@Name(value="map1", description="The first map to merge with the second map.") Map<String, Object> first, @Name(value="map2", description="The second map to merge with the first map.") Map<String, Object> second) {
        return Util.merge(first, second);
    }

    @UserFunction(value="apoc.map.mergeList")
    @Description(value="Merges all `MAP` values in the given `LIST<MAP<STRING, ANY>>` into one `MAP`.")
    public Map<String, Object> mergeList(@Name(value="maps", description="A list of maps to merge.") List<Map<String, Object>> maps) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(maps.size());
        for (Map<String, Object> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    @UserFunction(value="apoc.map.get")
    @Description(value="Returns a value for the given key.\nIf the given key does not exist, or lacks a default value, this function will throw an exception.")
    public Object get(@Name(value="map", description="The map to extract a value from.") Map<String, Object> map, @Name(value="key", description="The key to extract.") String key, @Name(value="value", defaultValue="null", description="The default value of the given key.") Object value, @Name(value="fail", defaultValue="true", description="If a key is not present and no default is provided, it will either throw an exception if true, or return a null value") boolean fail) {
        if (fail && value == null && !map.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " is not of one of the existing keys " + String.valueOf(map.keySet()));
        }
        return map.getOrDefault(key, value);
    }

    @UserFunction(value="apoc.map.mget")
    @Description(value="Returns a `LIST<ANY>` for the given keys.\nIf one of the keys does not exist, or lacks a default value, this function will throw an exception.")
    public List<Object> mget(@Name(value="map", description="The map to extract a list of values from.") Map<String, Object> map, @Name(value="keys", description="The list of keys to extract.") List<String> keys, @Name(value="values", defaultValue="[]", description="The default values of the given keys.") List<Object> values, @Name(value="fail", defaultValue="true", description="If a key is not present and no default is provided, it will either throw an exception if true, or return a null value") boolean fail) {
        if (keys == null || map == null) {
            return null;
        }
        int keySize = keys.size();
        ArrayList<Object> result = new ArrayList<Object>(keySize);
        int valuesSize = values == null ? -1 : values.size();
        for (int i = 0; i < keySize; ++i) {
            result.add(this.get(map, keys.get(i), i < valuesSize ? values.get(i) : null, fail));
        }
        return result;
    }

    @UserFunction(value="apoc.map.submap")
    @Description(value="Returns a sub-map for the given keys.\nIf one of the keys does not exist, or lacks a default value, this function will throw an exception.")
    public Map<String, Object> submap(@Name(value="map", description="The map to extract a submap from.") Map<String, Object> map, @Name(value="keys", description="The list of keys to extract into a submap.") List<String> keys, @Name(value="values", defaultValue="[]", description="The default values of the given keys.") List<Object> values, @Name(value="fail", defaultValue="true", description="If a key is not present and no default is provided, it will either throw an exception if true, or return a null value.") boolean fail) {
        if (keys == null || map == null) {
            return null;
        }
        int keySize = keys.size();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(keySize);
        int valuesSize = values == null ? -1 : values.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            result.put(key, this.get(map, key, i < valuesSize ? values.get(i) : null, fail));
        }
        return result;
    }

    @UserFunction(value="apoc.map.setKey")
    @Description(value="Adds or updates the given entry in the `MAP`.")
    public Map<String, Object> setKey(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="key", description="The key to add or update the map with.") String key, @Name(value="value", description="The value to set the given key to.") Object value) {
        return Util.merge(map, Util.map(key, value));
    }

    @UserFunction(name="apoc.map.setEntry", deprecatedBy="apoc.map.setKey")
    @Deprecated
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Adds or updates the given entry in the `MAP`.")
    public Map<String, Object> setEntry(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="key", description="The key to add or update the map with.") String key, @Name(value="value", description="The value to set the given key to.") Object value) {
        return Util.merge(map, Util.map(key, value));
    }

    @UserFunction(value="apoc.map.setPairs")
    @Description(value="Adds or updates the given key/value pairs (e.g. [key1,value1],[key2,value2]) in a `MAP`.")
    public Map<String, Object> setPairs(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="pairs", description="A list of pairs to add or update the map with.") List<List<Object>> pairs) {
        return Util.merge(map, Util.mapFromPairs(pairs));
    }

    @UserFunction(value="apoc.map.setLists")
    @Description(value="Adds or updates the given keys/value pairs provided in `LIST<ANY>` format (e.g. [key1, key2],[value1, value2]) in a `MAP`.")
    public Map<String, Object> setLists(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="keys", description="A list of keys to add or update the map with.") List<String> keys, @Name(value="values", description="A list of values associated to the keys to add or update the map with.") List<Object> values) {
        return Util.merge(map, Util.mapFromLists(keys, values));
    }

    @UserFunction(value="apoc.map.setValues")
    @Description(value="Adds or updates the alternating key/value pairs (e.g. [key1,value1,key2,value2]) in a `MAP`.")
    public Map<String, Object> setValues(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="pairs", description="A list of items listed pairwise to add or update the map with.") List<Object> pairs) {
        return Util.merge(map, Util.map(pairs));
    }

    @UserFunction(value="apoc.map.removeKey")
    @Description(value="Removes the given key from the `MAP` (recursively if recursive is true).")
    public Map<String, Object> removeKey(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="key", description="The key to remove from the map.") String key, @Name(value="config", defaultValue="{}", description="{ recursive = false :: BOOLEAN }") Map<String, Object> config) {
        if (!map.containsKey(key)) {
            return map;
        }
        return this.removeKeys(map, Collections.singletonList(key), config);
    }

    @UserFunction(value="apoc.map.removeKeys")
    @Description(value="Removes the given keys from the `MAP` (recursively if recursive is true).")
    public Map<String, Object> removeKeys(@Name(value="map", description="The map to be updated.") Map<String, Object> map, @Name(value="keys", description="The keys to remove from the map.") List<String> keys, @Name(value="config", defaultValue="{}", description="{ recursive = false :: BOOLEAN }") Map<String, Object> config) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(map);
        res.keySet().removeAll(keys);
        Map<Object, Object> checkedConfig = config == null ? Collections.emptyMap() : config;
        boolean removeRecursively = Util.toBoolean(checkedConfig.getOrDefault("recursive", false));
        if (removeRecursively) {
            Iterator iterator = res.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() instanceof Map) {
                    Map<String, Object> updatedMap = this.removeKeys((Map)entry.getValue(), keys, checkedConfig);
                    if (updatedMap.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    if (updatedMap.equals(entry.getValue())) continue;
                    entry.setValue(updatedMap);
                    continue;
                }
                if (!(entry.getValue() instanceof Collection)) continue;
                Collection values = (Collection)entry.getValue();
                List updatedValues = values.stream().map(value -> value instanceof Map ? this.removeKeys((Map<String, Object>)value, keys, (Map<String, Object>)checkedConfig) : value).filter(value -> value instanceof Map ? !((Map)value).isEmpty() : true).collect(Collectors.toList());
                if (updatedValues.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(updatedValues);
            }
        }
        return res;
    }

    @UserFunction(value="apoc.map.clean")
    @Description(value="Filters the keys and values contained in the given `LIST<ANY>` values.")
    public Map<String, Object> clean(@Name(value="map", description="The map to clean.") Map<String, Object> map, @Name(value="keys", description="The list of property keys to be removed.") List<String> keys, @Name(value="values", description="The list of values to be removed.") List<Object> values) {
        HashSet<String> keySet = new HashSet<String>(keys);
        HashSet<Object> valueSet = new HashSet<Object>(values);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (keySet.contains(entry.getKey()) || value == null || valueSet.contains(value) || valueSet.contains(value.toString())) continue;
            res.put(entry.getKey(), value);
        }
        return res;
    }

    @UserFunction(value="apoc.map.updateTree")
    @Description(value="Adds the data `MAP` on each level of the nested tree, where the key-value pairs match.")
    public Map<String, Object> updateTree(@Name(value="tree", description="The map to be updated.") Map<String, Object> tree, @Name(value="key", description="The name of the key to match on.") String key, @Name(value="data", description="A list of pairs, where the first item is the value to match with the given key, and the second is a map to add to the tree.") List<List<Object>> data) {
        HashMap<Object, Map> map = new HashMap<Object, Map>(data.size());
        for (List<Object> datum : data) {
            if (datum.size() < 2 || !(datum.get(1) instanceof Map)) {
                throw new IllegalArgumentException("Wrong data list entry: " + String.valueOf(datum));
            }
            map.put(datum.get(0), (Map)datum.get(1));
        }
        return this.visit(tree, m -> {
            Map entry = (Map)map.get(m.get(key));
            if (entry != null) {
                m.putAll(entry);
            }
            return m;
        });
    }

    Map<String, Object> visit(Map<String, Object> tree, Function<Map<String, Object>, Map<String, Object>> mapper) {
        Map<String, Object> result = mapper.apply(new LinkedHashMap<String, Object>(tree));
        result.entrySet().forEach(e -> {
            if (e.getValue() instanceof List) {
                List list = (List)e.getValue();
                List newList = list.stream().map(v -> {
                    if (v instanceof Map) {
                        Map map = (Map)v;
                        return this.visit(map, mapper);
                    }
                    return v;
                }).collect(Collectors.toList());
                e.setValue(newList);
            } else if (e.getValue() instanceof Map) {
                Map map = (Map)e.getValue();
                e.setValue(this.visit(map, mapper));
            }
        });
        return result;
    }

    @UserFunction(value="apoc.map.flatten")
    @Description(value="Flattens nested items in the given `MAP`.\nThis function is the reverse of the `apoc.map.unflatten` function.")
    public Map<String, Object> flatten(@Name(value="map", description="A nested map to flatten.") Map<String, Object> map, @Name(value="delimiter", defaultValue=".", description="The delimiter used to separate the levels of the flattened map.") String delimiter) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        this.flattenMapRecursively(flattenedMap, map, "", delimiter == null ? "." : delimiter);
        return flattenedMap;
    }

    private void flattenMapRecursively(Map<String, Object> flattenedMap, Map<String, Object> map, String prefix, String delimiter) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.flattenMapRecursively(flattenedMap, (Map)entry.getValue(), prefix + entry.getKey() + delimiter, delimiter);
                continue;
            }
            flattenedMap.put(prefix + entry.getKey(), entry.getValue());
        }
    }

    @UserFunction(value="apoc.map.unflatten")
    @Description(value="Unflattens items in the given `MAP` to nested items.\nThis function is the reverse of the `apoc.map.flatten` function.")
    public Map<String, Object> unflatten(@Name(value="map", description="The map to unflatten.") Map<String, Object> map, @Name(value="delimiter", defaultValue=".", description="The delimiter used to separate the levels of the flattened map.") String delimiter) {
        return this.unflattenMapRecursively(map, StringUtils.isBlank(delimiter) ? "." : delimiter);
    }

    private Map<String, Object> unflattenMapRecursively(Map<String, Object> inputMap, String delimiter) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            Maps.unflatEntry(resultMap, entry.getValue(), entry.getKey(), delimiter);
        }
        return resultMap;
    }

    public static void unflatEntry(Map<String, Object> map, Object value, String key, String delimiter) {
        String[] keys = key.split(Pattern.quote(delimiter), 2);
        String firstPart = keys[0];
        if (keys.length == 1) {
            map.put(firstPart, value);
        } else {
            Map currentMap = (Map)map.computeIfAbsent(firstPart, k -> new HashMap());
            Maps.unflatEntry(currentMap, value, keys[1], delimiter);
        }
    }

    @UserFunction(value="apoc.map.sortedProperties")
    @Description(value="Returns a `LIST<ANY>` of key/value pairs.\nThe pairs are sorted by alphabetically by key, with optional case sensitivity.")
    public List<List<Object>> sortedProperties(@Name(value="map", description="The map to extract the properties from.") Map<String, Object> map, @Name(value="ignoreCase", defaultValue="true", description="Whether or not to take the case into account when sorting.") boolean ignoreCase) {
        ArrayList<List<Object>> sortedProperties = new ArrayList<List<Object>>();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        if (ignoreCase) {
            Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        } else {
            Collections.sort(keys);
        }
        for (String key : keys) {
            sortedProperties.add(Arrays.asList(key, map.get(key)));
        }
        return sortedProperties;
    }
}

