/*
 * Decompiled with CFR 0.152.
 */
package apoc.math;

import apoc.math.SimpleRegression;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Regression {
    @Context
    public Transaction tx;

    @Procedure(name="apoc.math.regr", mode=Mode.READ)
    @Description(value="Returns the coefficient of determination (R-squared) for the values of propertyY and propertyX in the given label.")
    public Stream<Output> regr(@Name(value="label", description="The label of the nodes to perform the regression on.") String label, @Name(value="propertyY", description="The name of the y property.") String y, @Name(value="propertyX", description="The name of the x property.") String x) {
        SimpleRegression regr = new SimpleRegression();
        double regrAvgX = 0.0;
        double regrAvgY = 0.0;
        int count = 0;
        try (ResourceIterator it = this.tx.findNodes(Label.label((String)label));){
            while (it.hasNext()) {
                Node node = (Node)it.next();
                Number propX = (Number)node.getProperty(x, null);
                Number propY = (Number)node.getProperty(y, null);
                if (propX == null || propY == null) continue;
                regrAvgX += propX.doubleValue();
                regrAvgY += propY.doubleValue();
                regr.addData(propX.doubleValue(), propY.doubleValue());
                ++count;
            }
        }
        return Stream.of(new Output(regr.getRSquare(), regrAvgX /= (double)count, regrAvgY /= (double)count, regr.getSlope()));
    }

    public static class Output {
        @Description(value="The coefficient of determination.")
        public double r2;
        @Description(value="The average of the x values.")
        public double avgX;
        @Description(value="The average of the y values.")
        public double avgY;
        @Description(value="The calculated slope.")
        public double slope;

        public Output(double r2, double avgX, double avgY, double slope) {
            this.r2 = r2;
            this.avgX = avgX;
            this.avgY = avgY;
            this.slope = slope;
        }
    }
}

