/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.export.util.NodesAndRelsSubGraph;
import apoc.meta.MetaConfig;
import apoc.meta.SampleMetaConfig;
import apoc.meta.Types;
import apoc.result.VirtualGraph;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Meta {
    @Context
    public Transaction tx;
    @Context
    public Transaction transaction;
    @Context
    public Log log;
    @Context
    public ProcedureCallContext procedureCallContext;

    @UserFunction(value="apoc.meta.cypher.isType")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns true if the given value matches the given type.")
    public boolean isTypeCypherCypher5(@Name(value="value", description="An object to check the type of.") Object value, @Name(value="type", description="The verification type.") String type) {
        return type.equalsIgnoreCase(this.typeCypher(value));
    }

    @Deprecated
    @UserFunction(name="apoc.meta.cypher.isType", deprecatedBy="Cypher's type predicate expressions: `value IS :: <TYPE>`.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns true if the given value matches the given type.")
    public boolean isTypeCypher(@Name(value="value", description="An object to check the type of.") Object value, @Name(value="type", description="The verification type.") String type) {
        return type.equalsIgnoreCase(this.typeCypher(value));
    }

    @UserFunction(value="apoc.meta.cypher.type")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns the type name of the given value.")
    public String typeCypherCypher5(@Name(value="value", description="An object to get the type of.") Object value) {
        return this.typeCypher(value);
    }

    @Deprecated
    @UserFunction(name="apoc.meta.cypher.type", deprecatedBy="Cypher's `valueType()` function.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns the type name of the given value.")
    public String typeCypher(@Name(value="value", description="An object to get the type of.") Object value) {
        Types type = Types.of(value);
        switch (type) {
            case ANY: {
                return value.getClass().getSimpleName();
            }
        }
        return type.toString();
    }

    @UserFunction(value="apoc.meta.cypher.types")
    @Description(value="Returns a `MAP` containing the type names of the given values.")
    public Map<String, Object> typesCypher(@Name(value="props", description="A relationship, node or map to get the property types from.") Object target) {
        Map properties = Collections.emptyMap();
        if (target instanceof Node) {
            properties = ((Node)target).getAllProperties();
        }
        if (target instanceof Relationship) {
            properties = ((Relationship)target).getAllProperties();
        }
        if (target instanceof Map) {
            properties = (Map)target;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties.size());
        properties.forEach((key, value) -> result.put((String)key, this.typeCypher(value)));
        return result;
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.data.of")
    @Description(value="Examines the given sub-graph and returns a table of metadata.")
    public Stream<MetaResult> dataOf(@Name(value="graph", description="The graph to extract metadata from.") Object graph, @Name(value="config", defaultValue="{}", description="Number of nodes to sample, setting sample to `-1` will remove sampling; { sample = 1000 :: INTEGER }") Map<String, Object> config) {
        SubGraph subGraph;
        MetaConfig metaConfig = new MetaConfig(config);
        if (graph instanceof String) {
            Result result = this.tx.execute(Util.prefixQueryWithCheck(this.procedureCallContext, (String)graph));
            subGraph = CypherResultSubGraph.from(this.tx, result, metaConfig.isAddRelationshipsBetweenNodes());
        } else if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are String, VirtualGraph, Map");
        }
        return this.collectMetaData(subGraph, metaConfig.getSampleMetaConfig()).values().stream().flatMap(x -> x.values().stream());
    }

    private Map<MetadataKey, Map<String, MetaItem>> collectMetaData(SubGraph graph, SampleMetaConfig config) {
        LinkedHashMap<MetadataKey, Map<String, MetaItem>> metaData = new LinkedHashMap<MetadataKey, Map<String, MetaItem>>(100);
        Set<RelationshipType> types = Iterables.asSet(graph.getAllRelationshipTypesInUse());
        HashMap<String, Iterable<ConstraintDefinition>> relConstraints = new HashMap<String, Iterable<ConstraintDefinition>>(20);
        HashMap<String, Set<String>> relIndexes = new HashMap<String, Set<String>>();
        for (RelationshipType type : graph.getAllRelationshipTypesInUse()) {
            metaData.put(new MetadataKey(Types.RELATIONSHIP, type.name()), new LinkedHashMap(10));
            relConstraints.put(type.name(), graph.getConstraints(type));
            relIndexes.put(type.name(), this.getIndexedProperties(graph.getIndexes(type)));
        }
        for (Label label : graph.getAllLabelsInUse()) {
            LinkedHashMap<String, MetaItem> nodeMeta = new LinkedHashMap<String, MetaItem>(50);
            String labelName = label.name();
            metaData.put(new MetadataKey(Types.NODE, labelName), nodeMeta);
            Iterable<ConstraintDefinition> constraints = graph.getConstraints(label);
            Set<String> indexed = this.getIndexedProperties(graph.getIndexes(label));
            long labelCount = graph.countsForNode(label);
            long sample = Meta.getSampleForLabelCount(labelCount, config.getSample());
            Iterator<Node> nodes = graph.findNodes(label);
            int count = 1;
            while (nodes.hasNext()) {
                Node node = nodes.next();
                if ((long)count++ % sample != 0L) continue;
                this.addRelationships(metaData, nodeMeta, labelName, node, relConstraints, types, relIndexes);
                this.addProperties(nodeMeta, labelName, constraints, indexed, (Entity)node, node);
            }
        }
        return metaData;
    }

    private Set<String> getIndexedProperties(Iterable<IndexDefinition> indexes) {
        return Iterables.stream(indexes).map(IndexDefinition::getPropertyKeys).flatMap(Iterables::stream).collect(Collectors.toSet());
    }

    public static long getSampleForLabelCount(long labelCount, long sample) {
        if (sample != -1L) {
            long max;
            long skipCount = labelCount / sample;
            long min = (long)Math.floor((double)skipCount - (double)skipCount * 0.1);
            if (min >= (max = (long)Math.ceil((double)skipCount + (double)skipCount * 0.1))) {
                return -1L;
            }
            long randomValue = ThreadLocalRandom.current().nextLong(min, max);
            return randomValue == 0L ? -1L : randomValue;
        }
        return sample;
    }

    private void addProperties(Map<String, MetaItem> properties, String labelName, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Entity pc, Node node) {
        for (String prop : pc.getPropertyKeys()) {
            if (properties.containsKey(prop)) continue;
            MetaItem res = this.metaResultForProp(pc, labelName, prop);
            res.elementType(Types.of(pc).name());
            this.addSchemaInfo(res, prop, constraints, indexed, node);
            properties.put(prop, res);
        }
    }

    private void addRelationships(Map<MetadataKey, Map<String, MetaItem>> metaData, Map<String, MetaItem> nodeMeta, String labelName, Node node, Map<String, Iterable<ConstraintDefinition>> relConstraints, Set<RelationshipType> types, Map<String, Set<String>> relIndexes) {
        StreamSupport.stream(node.getRelationshipTypes().spliterator(), false).filter(type -> types.contains(type)).forEach(type -> {
            int out = node.getDegree(type, Direction.OUTGOING);
            if (out == 0) {
                return;
            }
            String typeName = type.name();
            Iterable constraints = (Iterable)relConstraints.get(typeName);
            Set indexes = (Set)relIndexes.get(typeName);
            if (!nodeMeta.containsKey(typeName)) {
                nodeMeta.put(typeName, new MetaItem(labelName, typeName));
            }
            int in = node.getDegree(type, Direction.INCOMING);
            Map typeMeta = (Map)metaData.get(new MetadataKey(Types.RELATIONSHIP, typeName));
            if (!typeMeta.containsKey(labelName)) {
                typeMeta.put(labelName, new MetaItem(typeName, labelName));
            }
            MetaItem relMeta = (MetaItem)nodeMeta.get(typeName);
            this.addOtherNodeInfo(node, labelName, out, in, (RelationshipType)type, relMeta, typeMeta, constraints, indexes);
        });
    }

    private void addOtherNodeInfo(Node node, String labelName, int out, int in, RelationshipType type, MetaItem relMeta, Map<String, MetaItem> typeMeta, Iterable<ConstraintDefinition> relConstraints, Set<String> indexes) {
        MetaItem relNodeMeta = typeMeta.get(labelName);
        relMeta.elementType(Types.of(node).name());
        relMeta.inc().rel(out, in);
        relNodeMeta.inc().rel(out, in);
        for (Relationship rel : node.getRelationships(Direction.OUTGOING, new RelationshipType[]{type})) {
            Node endNode = rel.getEndNode();
            List<String> labels = this.toStrings(endNode.getLabels());
            relMeta.other(labels);
            relNodeMeta.other(labels);
            this.addProperties(typeMeta, type.name(), relConstraints, indexes, (Entity)rel, node);
            relNodeMeta.elementType(Types.RELATIONSHIP.name());
        }
    }

    private void addSchemaInfo(MetaItem res, String prop, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Node node) {
        if (indexed.contains(prop)) {
            res.index = true;
        }
        if (constraints == null) {
            return;
        }
        for (ConstraintDefinition constraint : constraints) {
            for (String key : constraint.getPropertyKeys()) {
                if (!key.equals(prop)) continue;
                switch (constraint.getConstraintType()) {
                    case UNIQUENESS: {
                        res.unique = true;
                        node.getLabels().forEach(l -> {
                            if (res.label != l.name()) {
                                res.addLabel(l.name());
                            }
                        });
                        break;
                    }
                    case RELATIONSHIP_UNIQUENESS: {
                        res.unique = true;
                        break;
                    }
                    case NODE_PROPERTY_EXISTENCE: 
                    case RELATIONSHIP_PROPERTY_EXISTENCE: {
                        res.existence = true;
                    }
                }
            }
        }
    }

    private MetaItem metaResultForProp(Entity pc, String labelName, String prop) {
        MetaItem res = new MetaItem(labelName, prop);
        Object value = pc.getProperty(prop);
        res.type(Types.of(value).name());
        res.elementType(Types.of(pc).name());
        if (value.getClass().isArray()) {
            res.array = true;
        }
        return res;
    }

    private List<String> toStrings(Iterable<Label> labels) {
        ArrayList<String> res = new ArrayList<String>(10);
        for (Label label : labels) {
            String name = label.name();
            res.add(name);
        }
        return res;
    }

    static boolean relationshipExists(Transaction tx, Label labelFromLabel, Label labelToLabel, RelationshipType relationshipType, Direction direction, SampleMetaConfig metaConfig) {
        try (ResourceIterator nodes = tx.findNodes(labelFromLabel);){
            long skipCount;
            long count = 0L;
            long l = skipCount = metaConfig.getSample() > 0L ? metaConfig.getSample() : 1L;
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (count % skipCount == 0L) {
                    long maxRels = metaConfig.getMaxRels();
                    for (Relationship rel : node.getRelationships(direction, new RelationshipType[]{relationshipType})) {
                        Node otherNode;
                        Node node2 = otherNode = direction == Direction.OUTGOING ? rel.getEndNode() : rel.getStartNode();
                        if (otherNode.hasLabel(labelToLabel)) {
                            boolean bl = true;
                            return bl;
                        }
                        if (maxRels == -1L || maxRels-- != 0L) continue;
                        break;
                    }
                }
                ++count;
            }
        }
        return false;
    }

    private record MetadataKey(Types type, String key) {
    }

    public static class MetaItem
    extends MetaResult {
        public long leftCount;
        public long rightCount;

        public MetaItem addLabel(String label) {
            this.otherLabels.add(label);
            return this;
        }

        public MetaItem(String label, String name) {
            this.label = label;
            this.property = name;
        }

        public MetaItem inc() {
            ++this.count;
            return this;
        }

        public MetaItem rel(long out, long in) {
            this.type = Types.RELATIONSHIP.name();
            if (out > 1L) {
                this.array = true;
            }
            this.leftCount += out;
            this.rightCount += in;
            this.left = this.leftCount / this.count;
            this.right = this.rightCount / this.count;
            return this;
        }

        public MetaItem other(List<String> labels) {
            for (String l : labels) {
                if (this.other.contains(l)) continue;
                this.other.add(l);
            }
            return this;
        }

        public MetaItem type(String type) {
            this.type = type;
            return this;
        }

        public MetaItem array(boolean array) {
            this.array = array;
            return this;
        }

        public MetaItem elementType(String elementType) {
            switch (elementType) {
                case "NODE": {
                    this.elementType = "node";
                    break;
                }
                case "RELATIONSHIP": {
                    this.elementType = "relationship";
                }
            }
            return this;
        }
    }

    public static class MetaResult {
        @Description(value="The label or type name.")
        public String label;
        @Description(value="The property name.")
        public String property;
        @Description(value="The count of seen values.")
        public long count;
        @Description(value="If all seen values are unique.")
        public boolean unique;
        @Description(value="If an index exists for this property.")
        public boolean index;
        @Description(value="If an existence constraint exists for this property.")
        public boolean existence;
        @Description(value="The type represented by this row.")
        public String type;
        @Description(value="Indicates whether the property is an array. If the type column is \"RELATIONSHIP,\" this will be true if there is at least one node with two outgoing relationships of the type specified by the label or property column.")
        public boolean array;
        @Description(value="This is always null.")
        public List<Object> sample;
        @Description(value="The ratio (rounded down) of the count of outgoing relationships for a specific label and relationship type relative to the total count of those patterns.")
        public long left;
        @Description(value="The ratio (rounded down) of the count of incoming relationships for a specific label and relationship type relative to the total count of those patterns.")
        public long right;
        @Description(value="The labels of connect nodes.")
        public List<String> other = new ArrayList<String>();
        @Description(value="For uniqueness constraints, this field shows other labels present on nodes that also contain the uniqueness constraint.")
        public List<String> otherLabels = new ArrayList<String>();
        @Description(value="Whether this refers to a node or a relationship.")
        public String elementType;
    }
}

