/*
 * Decompiled with CFR 0.152.
 */
package apoc.nodes;

import apoc.Pools;
import apoc.result.VirtualNode;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.exceptions.ArithmeticException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.Comparison;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Grouping {
    private static final int BATCHSIZE = 10000;
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;
    @Context
    public Pools pools;

    @NotThreadSafe
    @Procedure(value="apoc.nodes.group")
    @Description(value="Allows for the aggregation of `NODE` values based on the given properties.\nThis procedure returns virtual `NODE` values.")
    public Stream<GroupResult> group(@Name(value="labels", description="The list of node labels to aggregate over. Use `['*']` to indicate all node labels should be looked at.") List<String> labelNames, @Name(value="groupByProperties", description="The property keys to group the nodes by.") List<String> groupByProperties, @Name(value="aggregations", defaultValue="[{`*`:\"count\"},{`*`:\"count\"}]", description="The first map specifies the node properties to aggregate with their corresponding aggregation functions, while the second map specifies the relationship properties for aggregation.") List<Map<String, Object>> aggregations, @Name(value="config", defaultValue="{}", description="{\n    includeRels :: STRING | LIST<STRING>\n    excludeRels :: STRING | LIST<STRING>,\n    orphans = true :: BOOLEAN,\n    selfRels = true :: BOOLEAN,\n    limitNodes = -1 :: INTEGER,\n    limitRels = -1 :: INTEGER,\n    relsPerNode = -1 :: INTEGER,\n    filter :: MAP\n}\n") Map<String, Object> config) {
        HashSet<String> labels = new HashSet<String>(labelNames);
        if (labels.remove("*")) {
            labels.addAll(Iterables.stream(this.tx.getAllLabels()).map(Label::name).collect(Collectors.toSet()));
        }
        String[] keys = groupByProperties.toArray(new String[groupByProperties.size()]);
        if (aggregations == null || aggregations.isEmpty()) {
            aggregations = Arrays.asList(Collections.singletonMap("*", "count"), Collections.singletonMap("*", "count"));
        }
        Map nodeAggNames = aggregations.size() > 0 ? this.toStringListMap(aggregations.get(0)) : Collections.emptyMap();
        String[] nodeAggKeys = this.keyArray(nodeAggNames, "*");
        Map relAggNames = aggregations.size() > 1 ? this.toStringListMap(aggregations.get(1)) : Collections.emptyMap();
        String[] relAggKeys = this.keyArray(relAggNames, "*");
        Set<String> includeRels = this.computeIncludedRels(config);
        boolean orphans = (Boolean)config.getOrDefault("orphans", true);
        boolean selfRels = (Boolean)config.getOrDefault("selfRels", true);
        long limitNodes = (Long)config.getOrDefault("limitNodes", -1L);
        long limitRels = (Long)config.getOrDefault("limitRels", -1L);
        long relsPerNode = (Long)config.getOrDefault("relsPerNode", -1L);
        Map<String, Number> filter = this.configuredFilter(config);
        ConcurrentHashMap grouped = new ConcurrentHashMap();
        ConcurrentHashMap virtualNodes = new ConcurrentHashMap();
        ConcurrentHashMap virtualRels = new ConcurrentHashMap();
        ArrayList<Future> futures = new ArrayList<Future>(1000);
        ExecutorService pool = this.pools.getDefaultExecutorService();
        for (String labelName : labels) {
            Label label = Label.label((String)labelName);
            Label[] singleLabel = new Label[]{label};
            ResourceIterator nodes = labelName.equals("*") ? this.tx.getAllNodes().iterator() : this.tx.findNodes(label);
            try {
                while (nodes.hasNext()) {
                    List batch = Util.take(nodes, 10000);
                    futures.add(Util.inTxFuture(pool, this.db, txInThread -> {
                        try {
                            for (Node node : batch) {
                                Node boundNode = Util.rebind(txInThread, node);
                                NodeKey key = this.keyFor(boundNode, labelName, keys);
                                grouped.compute(key, (k, v) -> {
                                    if (v == null) {
                                        v = new HashSet<Node>();
                                    }
                                    v.add(boundNode);
                                    return v;
                                });
                                virtualNodes.compute(key, (k, v) -> {
                                    if (v == null) {
                                        v = new VirtualNode(singleLabel, this.propertiesFor(boundNode, keys));
                                    }
                                    VirtualNode vn = v;
                                    if (!nodeAggNames.isEmpty()) {
                                        this.aggregate((Entity)vn, nodeAggNames, nodeAggKeys.length > 0 ? boundNode.getProperties(nodeAggKeys) : Collections.emptyMap());
                                    }
                                    return vn;
                                });
                            }
                        }
                        catch (Exception e) {
                            this.log.error("Error grouping nodes", (Throwable)e);
                        }
                        return null;
                    }));
                    Util.removeFinished(futures);
                }
            }
            finally {
                if (nodes == null) continue;
                nodes.close();
            }
        }
        Util.waitForFutures(futures);
        futures.clear();
        Iterator entries = grouped.entrySet().iterator();
        int size = 0;
        ArrayList batch = new ArrayList();
        while (entries.hasNext()) {
            Map.Entry outerEntry = entries.next();
            batch.add(outerEntry);
            if ((size += ((Set)outerEntry.getValue()).size()) <= 10000 && entries.hasNext()) continue;
            ArrayList submitted = new ArrayList(batch);
            batch.clear();
            size = 0;
            futures.add(Util.inTxFuture(pool, this.db, txInThread -> {
                try {
                    for (Map.Entry entry : submitted) {
                        for (Node node : (Set)entry.getValue()) {
                            node = Util.rebind(txInThread, node);
                            NodeKey startKey = (NodeKey)entry.getKey();
                            VirtualNode v1 = (VirtualNode)virtualNodes.get(startKey);
                            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                                if (includeRels != null && !includeRels.contains(rel.getType().name())) continue;
                                Node endNode = rel.getEndNode();
                                for (NodeKey endKey : this.keysFor(endNode, labels, keys)) {
                                    VirtualNode v2 = (VirtualNode)virtualNodes.get(endKey);
                                    if (v2 == null || !selfRels && startKey.equals(endKey)) continue;
                                    virtualRels.compute(new RelKey(startKey, endKey, rel), (rk, vRel) -> {
                                        if (vRel == null) {
                                            vRel = v1.createRelationshipTo(v2, rel.getType());
                                        }
                                        if (!relAggNames.isEmpty()) {
                                            this.aggregate((Entity)vRel, relAggNames, relAggKeys.length > 0 ? rel.getProperties(relAggKeys) : Collections.emptyMap());
                                        }
                                        return vRel;
                                    });
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("Error grouping relationships", (Throwable)e);
                }
                return null;
            }));
            Util.removeFinished(futures);
        }
        Util.waitForFutures(futures);
        Stream<Object> stream = this.fixAggregates(virtualNodes.values()).stream();
        if (filter != null) {
            stream = stream.filter(n -> this.filter(n.getLabels(), n.getAllProperties(), filter));
        }
        if (limitNodes > -1L) {
            stream = stream.limit(limitNodes);
        }
        Stream<GroupResult> groupResultStream = stream.map(n -> new GroupResult((Node)n, this.getRelationships((Node)n, filter, (int)relsPerNode)));
        if (!orphans) {
            groupResultStream = groupResultStream.filter(g -> g.relationships != null && !g.relationships.isEmpty() && g.node.getDegree() > 0);
        }
        groupResultStream = groupResultStream.flatMap(GroupResult::spread);
        if (limitRels > -1L) {
            groupResultStream = groupResultStream.limit(limitRels);
        }
        return groupResultStream;
    }

    private Map<String, Number> configuredFilter(Map<String, Object> config) {
        Map filter = (Map)config.get("filter");
        if (filter == null || filter.isEmpty()) {
            return null;
        }
        return filter;
    }

    private boolean filter(String type, Map<String, Object> props, Map<String, Number> filter) {
        if (filter == null || props.isEmpty()) {
            return true;
        }
        return this.filterProps(type, props, filter);
    }

    private boolean filter(Iterable<Label> types, Map<String, Object> props, Map<String, Number> filter) {
        if (filter == null || props.isEmpty()) {
            return true;
        }
        for (Label label : types) {
            String type = label.name();
            if (this.filterProps(type, props, filter)) continue;
            return false;
        }
        return true;
    }

    private boolean filterProps(String type, Map<String, Object> props, Map<String, Number> filter) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!(entry.getValue() instanceof Number)) continue;
            long value = ((Number)entry.getValue()).longValue();
            Number min = filter.getOrDefault(type + "." + entry.getKey() + ".min", filter.get(entry.getKey() + ".min"));
            if (min != null && min.longValue() > value) {
                return false;
            }
            Number max = filter.getOrDefault(type + "." + entry.getKey() + ".max", filter.get(entry.getKey() + ".max"));
            if (max == null || max.longValue() >= value) continue;
            return false;
        }
        return true;
    }

    public List<Relationship> getRelationships(Node n, Map<String, Number> filter, int relsPerNode) {
        List<Relationship> rels = this.fixAggregates(Iterables.asList(n.getRelationships(Direction.OUTGOING)));
        if (filter != null) {
            rels.removeIf(r -> !this.filter(r.getType().name(), (Map<String, Object>)r.getAllProperties(), filter));
        }
        if (relsPerNode > -1) {
            rels = rels.subList(0, Math.min(relsPerNode, rels.size()));
        }
        return rels;
    }

    public Set<String> computeIncludedRels(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Object rels;
        if (!config.containsKey("includeRels") && !config.containsKey("excludeRels")) {
            return null;
        }
        Set<String> includeRels = Iterables.stream(this.tx.getAllRelationshipTypes()).map(RelationshipType::name).collect(Collectors.toSet());
        if (config.containsKey("includeRels")) {
            rels = config.get("includeRels");
            if (rels instanceof Collection) {
                includeRels.retainAll((Collection)rels);
            }
            if (rels instanceof String) {
                includeRels.retainAll(Collections.singleton(rels));
            }
        }
        if (config.containsKey("excludeRels")) {
            rels = config.get("excludeRels");
            if (rels instanceof Collection) {
                includeRels.removeAll((Collection)rels);
            }
            if (rels instanceof String) {
                includeRels.remove(rels);
            }
        }
        return includeRels;
    }

    private Map<String, List<String>> toStringListMap(Map<String, Object> input) {
        LinkedHashMap<String, List<String>> nodeAggNames = new LinkedHashMap<String, List<String>>(input.size());
        input.forEach((k, v) -> nodeAggNames.put((String)k, (List<String>)(v instanceof List ? ((List)v).stream().map(Object::toString).collect(Collectors.toList()) : Collections.singletonList(v.toString()))));
        return nodeAggNames;
    }

    private String[] keyArray(Map<String, ?> map, String ... removeKeys) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        for (String key : removeKeys) {
            keys.remove(key);
        }
        return keys.toArray(new String[keys.size()]);
    }

    private <C extends Collection<T>, T extends Entity> C fixAggregates(C pcs) {
        for (Entity pc : pcs) {
            pc.getAllProperties().entrySet().forEach(entry -> {
                Object v = entry.getValue();
                String k = (String)entry.getKey();
                if (k.matches("^(min|max|sum)_.+") && v instanceof Number && ((Number)v).doubleValue() == (double)((Number)v).longValue()) {
                    entry.setValue(((Number)v).longValue());
                }
                if (k.matches("^avg_.+") && v instanceof double[]) {
                    double[] values = (double[])v;
                    entry.setValue(values[1] == 0.0 ? 0.0 : values[0] / values[1]);
                }
                if (k.matches("^avg_.+") && v instanceof DurationValue) {
                    DurationValue duration = (DurationValue)v;
                    Long count = ((Number)pc.getProperty(k + "_count", (Object)0)).longValue();
                    entry.setValue(this.divDurationValue(duration, count));
                }
                if (k.matches("^collect_.+") && v instanceof Collection) {
                    entry.setValue(((Collection)v).toArray());
                }
            });
        }
        return pcs;
    }

    public DurationValue divDurationValue(DurationValue div, Long number) {
        double divisor = number.doubleValue();
        try {
            return DurationValue.approximate((double)((double)div.get("months").longValue() / divisor), (double)((double)div.get("days").longValue() / divisor), (double)((double)div.get("seconds").longValue() / divisor), (double)((double)div.get("nanoseconds").longValue() / divisor));
        }
        catch (java.lang.ArithmeticException | ArithmeticException e) {
            return div;
        }
    }

    private void aggregate(Entity pc, Map<String, List<String>> aggregations, Map<String, Object> properties) {
        aggregations.forEach((k2, aggNames) -> {
            for (String aggName : aggNames) {
                String key = aggName + "_" + k2;
                if ("count_*".equals(key)) {
                    pc.setProperty(key, (Object)(((Number)pc.getProperty(key, (Object)0)).longValue() + 1L));
                    continue;
                }
                Object value = properties.get(k2);
                if (value == null) continue;
                switch (aggName) {
                    case "collect": {
                        List existing = (List)pc.getProperty(key, new ArrayList());
                        existing.add(value);
                        pc.setProperty(key, (Object)existing);
                        break;
                    }
                    case "count": {
                        pc.setProperty(key, (Object)(((Number)pc.getProperty(key, (Object)0)).longValue() + 1L));
                        break;
                    }
                    case "sum": {
                        if (value instanceof DurationValue) {
                            DurationValue duration = (DurationValue)value;
                            DurationValue dv = (DurationValue)pc.getProperty(key, (Object)DurationValue.duration((long)0L, (long)0L, (long)0L, (long)0L));
                            pc.setProperty(key, (Object)duration.add(dv));
                            break;
                        }
                        if (!(value instanceof Number)) break;
                        pc.setProperty(key, (Object)(((Number)pc.getProperty(key, (Object)0)).doubleValue() + Util.toDouble(value)));
                        break;
                    }
                    case "min": {
                        pc.setProperty(key, this.getMin(key, pc, value));
                        break;
                    }
                    case "max": {
                        pc.setProperty(key, this.getMax(key, pc, value));
                        break;
                    }
                    case "avg": {
                        if (value instanceof Number) {
                            double[] avg = (double[])pc.getProperty(key, (Object)new double[2]);
                            avg[0] = avg[0] + Util.toDouble(value);
                            avg[1] = avg[1] + 1.0;
                            pc.setProperty(key, (Object)avg);
                            break;
                        }
                        if (!(value instanceof DurationValue)) break;
                        DurationValue dv = (DurationValue)pc.getProperty(key, (Object)DurationValue.duration((long)0L, (long)0L, (long)0L, (long)0L));
                        pc.setProperty(key, (Object)((DurationValue)value).add(dv));
                        pc.setProperty(key + "_count", (Object)(((Number)pc.getProperty(key + "_count", (Object)0)).longValue() + 1L));
                    }
                }
            }
        });
    }

    private Object getMin(String key, Entity pc, Object value) {
        Object prop = pc.getProperty(key);
        if (prop == null) {
            return value;
        }
        Value valueA = Values.unsafeOf((Object)prop, (boolean)true);
        Value valueB = Values.unsafeOf((Object)value, (boolean)true);
        if (valueA == null) {
            valueA = Values.NO_VALUE;
        }
        if (valueB == null) {
            valueB = Values.NO_VALUE;
        }
        if (this.isComparableTypes(prop, value)) {
            return this.compareValues(valueA, valueB) ? prop : value;
        }
        return this.returnMinOfDifferentValues(prop, value);
    }

    private Object getMax(String key, Entity pc, Object value) {
        Object prop = pc.getProperty(key);
        if (prop == null) {
            return value;
        }
        Value valueA = Values.unsafeOf((Object)prop, (boolean)true);
        Value valueB = Values.unsafeOf((Object)value, (boolean)true);
        if (valueA == null) {
            valueA = Values.NO_VALUE;
        }
        if (valueB == null) {
            valueB = Values.NO_VALUE;
        }
        if (this.isComparableTypes(prop, value)) {
            return this.compareValues(valueA, valueB) ? value : prop;
        }
        return this.returnMaxOfDifferentValues(prop, value);
    }

    private boolean isComparableTypes(Object prop, Object value) {
        return prop instanceof ZonedDateTime && value instanceof ZonedDateTime || prop instanceof LocalDateTime && value instanceof LocalDateTime || prop instanceof LocalDate && value instanceof LocalDate || prop instanceof OffsetTime && value instanceof OffsetTime || prop instanceof LocalTime && value instanceof LocalTime || prop instanceof String && value instanceof String || prop instanceof Boolean && value instanceof Boolean || prop instanceof Number && value instanceof Number || (prop instanceof Collection || prop.getClass().isArray()) && (value instanceof Collection || value.getClass().isArray()) || prop instanceof PointValue && value instanceof PointValue;
    }

    private boolean compareValues(Value a, Value b) {
        return switch (Values.COMPARATOR.ternaryCompare(a, b)) {
            default -> throw new MatchException(null, null);
            case Comparison.UNDEFINED, Comparison.EQUAL, Comparison.SMALLER_THAN -> true;
            case Comparison.GREATER_THAN -> false;
        };
    }

    private Object returnMinOfDifferentValues(Object prop, Object value) {
        return this.orderOfType(prop) < this.orderOfType(value) ? prop : value;
    }

    private Object returnMaxOfDifferentValues(Object prop, Object value) {
        return this.orderOfType(prop) < this.orderOfType(value) ? value : prop;
    }

    private int orderOfType(Object value) {
        if (value != null && value.getClass().isArray()) {
            return 0;
        }
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, PointValue.class, ZonedDateTime.class, LocalDateTime.class, LocalDate.class, OffsetTime.class, LocalTime.class, DurationValue.class, String.class, Boolean.class, Number.class}, (Object)object, n)) {
            case -1 -> 11;
            case 0 -> {
                Collection ignored = (Collection)object;
                yield 0;
            }
            case 1 -> {
                PointValue ignored = (PointValue)object;
                yield 1;
            }
            case 2 -> {
                ZonedDateTime ignored = (ZonedDateTime)object;
                yield 2;
            }
            case 3 -> {
                LocalDateTime ignored = (LocalDateTime)object;
                yield 3;
            }
            case 4 -> {
                LocalDate ignored = (LocalDate)object;
                yield 4;
            }
            case 5 -> {
                OffsetTime ignored = (OffsetTime)object;
                yield 5;
            }
            case 6 -> {
                LocalTime ignored = (LocalTime)object;
                yield 6;
            }
            case 7 -> {
                DurationValue ignored = (DurationValue)object;
                yield 7;
            }
            case 8 -> {
                String ignored = (String)object;
                yield 8;
            }
            case 9 -> {
                Boolean ignored = (Boolean)object;
                yield 9;
            }
            case 10 -> {
                Number ignored = (Number)object;
                yield 10;
            }
            default -> 12;
        };
    }

    private Map<String, Object> propertiesFor(Node node, String[] keys) {
        HashMap<String, Object> props = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            props.put(key, node.getProperty(key, null));
        }
        return props;
    }

    private NodeKey keyFor(Node node, String label, String[] keys) {
        return new NodeKey(label, this.propertiesFor(node, keys));
    }

    private Collection<NodeKey> keysFor(Node node, Collection<String> labels, String[] keys) {
        Map<String, Object> props = this.propertiesFor(node, keys);
        ArrayList<NodeKey> result = new ArrayList<NodeKey>(labels.size());
        if (labels.contains("*")) {
            result.add(new NodeKey("*", props));
        } else {
            for (Label label : node.getLabels()) {
                if (!labels.contains(label.name())) continue;
                result.add(new NodeKey(label.name(), props));
            }
        }
        return result;
    }

    static class NodeKey {
        private final int hash;
        private final String label;
        private final Map<String, Object> values;

        NodeKey(String label, Map<String, Object> values) {
            this.label = label;
            this.values = values;
            this.hash = 31 * label.hashCode() + values.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeKey key = (NodeKey)o;
            return this.label.equals(key.label) && this.values.equals(key.values);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class GroupResult {
        @Description(value="A list of grouped nodes represented as virtual nodes.")
        public List<Node> nodes;
        @Description(value="A list of grouped relationships represented as virtual relationships.")
        public List<Relationship> relationships;
        @Description(value="The grouping node.")
        public Node node;
        @Description(value="The grouping relationship.")
        public Relationship relationship;

        public GroupResult(Node node, Relationship relationship) {
            this.node = node;
            this.relationship = relationship;
            this.nodes = Collections.singletonList(node);
            this.relationships = Collections.singletonList(relationship);
        }

        public GroupResult(Node node, List<Relationship> relationships) {
            this.nodes = Collections.singletonList(node);
            this.relationships = relationships;
            this.node = node;
            this.relationship = relationships.isEmpty() ? null : relationships.get(0);
        }

        public Stream<GroupResult> spread() {
            return Stream.concat(Stream.of(this), this.relationships.stream().skip(1L).map(r -> new GroupResult(this.node, (Relationship)r)));
        }
    }

    private static class RelKey {
        private final int hash;
        private final NodeKey startKey;
        private final NodeKey endKey;
        private final String type;

        RelKey(NodeKey startKey, NodeKey endKey, Relationship rel) {
            this.startKey = startKey;
            this.endKey = endKey;
            this.type = rel.getType().name();
            this.hash = 31 * (31 * startKey.hashCode() + endKey.hashCode()) + this.type.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelKey relKey = (RelKey)o;
            return this.startKey.equals(relKey.startKey) && this.endKey.equals(relKey.endKey) && this.type.equals(relKey.type);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

