/*
 * Decompiled with CFR 0.152.
 */
package apoc.nodes;

import apoc.Pools;
import apoc.path.RelationshipTypeAndDirections;
import apoc.refactor.util.RefactorConfig;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;
import org.neo4j.storageengine.api.RelationshipSelection;

public class NodesRestricted {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;
    @Context
    public Pools pools;
    @Context
    public ProcedureCallContext procedureCallContext;

    @Procedure(name="apoc.nodes.link", mode=Mode.WRITE)
    @Description(value="Creates a linked list of the given `NODE` values connected by the given `RELATIONSHIP` type.")
    public void link(@Name(value="nodes", description="The list of nodes to be linked.") List<Node> nodes, @Name(value="type", description="The relationship type name to link the nodes with.") String type, @Name(value="config", defaultValue="{}", description="{ avoidDuplicates = false :: BOOLEAN }") Map<String, Object> config) {
        RefactorConfig conf = new RefactorConfig(config);
        Iterator<Node> it = nodes.iterator();
        if (it.hasNext()) {
            RelationshipType relType = RelationshipType.withName((String)type);
            Node node = it.next();
            while (it.hasNext()) {
                boolean createRelationship;
                Node next = it.next();
                boolean bl = createRelationship = !conf.isAvoidDuplicates() || conf.isAvoidDuplicates() && !this.connected(node, next, type);
                if (createRelationship) {
                    node.createRelationshipTo(next, relType);
                }
                node = next;
            }
        }
    }

    @UserFunction(value="apoc.node.relationship.exists")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns a `BOOLEAN` based on whether the given `NODE` has a connecting `RELATIONSHIP` (or whether the given `NODE` has a connecting `RELATIONSHIP` of the given type and direction).")
    public boolean hasRelationshipCypher5(@Name(value="node", description="The node to check for the specified relationship types.") Node node, @Name(value="relTypes", defaultValue="", description="The relationship types to check for on the given node. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String types) {
        return this.hasRelationship(node, types);
    }

    @Deprecated
    @UserFunction(name="apoc.node.relationship.exists", deprecatedBy="Cypher's `EXISTS {}` expression.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns a `BOOLEAN` based on whether the given `NODE` has a connecting `RELATIONSHIP` (or whether the given `NODE` has a connecting `RELATIONSHIP` of the given type and direction).")
    public boolean hasRelationship(@Name(value="node", description="The node to check for the specified relationship types.") Node node, @Name(value="relTypes", defaultValue="", description="The relationship types to check for on the given node. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String types) {
        if (types == null || types.isEmpty()) {
            return node.hasRelationship();
        }
        long id = ((InternalTransaction)this.tx).elementIdMapper().nodeId(node.getElementId());
        try (NodeCursor nodeCursor = this.ktx.cursors().allocateNodeCursor(this.ktx.cursorContext());){
            this.ktx.dataRead().singleNode(id, nodeCursor);
            nodeCursor.next();
            TokenRead tokenRead = this.ktx.tokenRead();
            for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
                int count;
                int typeId = tokenRead.relationshipType(pair.getLeft().name());
                Direction direction = pair.getRight();
                switch (direction) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case INCOMING: {
                        int n = Nodes.countIncoming((NodeCursor)nodeCursor, (int)typeId);
                        break;
                    }
                    case OUTGOING: {
                        int n = Nodes.countOutgoing((NodeCursor)nodeCursor, (int)typeId);
                        break;
                    }
                    case BOTH: {
                        int n = count = Nodes.countAll((NodeCursor)nodeCursor, (int)typeId);
                    }
                }
                if (count <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @UserFunction(value="apoc.nodes.connected")
    @Description(value="Returns true when a given `NODE` is directly connected to another given `NODE`.\nThis function is optimized for dense nodes.")
    public boolean connected(@Name(value="startNode", description="The node to check if it is directly connected to the second node.") Node start, @Name(value="endNode", description="The node to check if it is directly connected to the first node.") Node end, @Name(value="types", defaultValue="", description="If not empty, provides an allow list of relationship types the nodes can be connected by. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String types) {
        if (start == null || end == null) {
            return false;
        }
        if (start.equals((Object)end)) {
            return true;
        }
        long startId = ((InternalTransaction)this.tx).elementIdMapper().nodeId(start.getElementId());
        long endId = ((InternalTransaction)this.tx).elementIdMapper().nodeId(end.getElementId());
        List<Pair<RelationshipType, Direction>> pairs = types == null || types.isEmpty() ? null : RelationshipTypeAndDirections.parse(types);
        Read dataRead = this.ktx.dataRead();
        TokenRead tokenRead = this.ktx.tokenRead();
        CursorFactory cursors = this.ktx.cursors();
        try (NodeCursor startNodeCursor = cursors.allocateNodeCursor(this.ktx.cursorContext());){
            boolean bl;
            block16: {
                NodeCursor endNodeCursor = cursors.allocateNodeCursor(this.ktx.cursorContext());
                try {
                    dataRead.singleNode(startId, startNodeCursor);
                    if (!startNodeCursor.next()) {
                        throw new IllegalArgumentException("node with id " + startId + " does not exist.");
                    }
                    dataRead.singleNode(endId, endNodeCursor);
                    if (!endNodeCursor.next()) {
                        throw new IllegalArgumentException("node with id " + endId + " does not exist.");
                    }
                    bl = this.connected(startNodeCursor, endId, this.typedDirections(tokenRead, pairs));
                    if (endNodeCursor == null) break block16;
                }
                catch (Throwable throwable) {
                    if (endNodeCursor != null) {
                        try {
                            endNodeCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                endNodeCursor.close();
            }
            return bl;
        }
    }

    private boolean connected(NodeCursor start, long end, int[][] typedDirections) {
        try (RelationshipTraversalCursor relationship = this.ktx.cursors().allocateRelationshipTraversalCursor(this.ktx.cursorContext());){
            start.relationships(relationship, RelationshipSelection.selection((Direction)Direction.BOTH));
            while (relationship.next()) {
                if (relationship.otherNodeReference() != end) continue;
                if (typedDirections == null) {
                    boolean bl = true;
                    return bl;
                }
                int direction = relationship.targetNodeReference() == end ? 0 : 1;
                int[] types = typedDirections[direction];
                if (!this.arrayContains(types, relationship.type())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean arrayContains(int[] array, int element) {
        for (int j : array) {
            if (j != element) continue;
            return true;
        }
        return false;
    }

    private int[][] typedDirections(TokenRead ops, List<Pair<RelationshipType, Direction>> pairs) {
        if (pairs == null) {
            return null;
        }
        int from = 0;
        int to = 0;
        int[][] result = new int[2][pairs.size()];
        int outIdx = Direction.OUTGOING.ordinal();
        int inIdx = Direction.INCOMING.ordinal();
        for (Pair<RelationshipType, Direction> pair : pairs) {
            int type = ops.relationshipType(pair.getLeft().name());
            if (type == -1) continue;
            if (pair.getRight() != Direction.INCOMING) {
                result[outIdx][from++] = type;
            }
            if (pair.getRight() == Direction.OUTGOING) continue;
            result[inIdx][to++] = type;
        }
        result[outIdx] = Arrays.copyOf(result[outIdx], from);
        result[inIdx] = Arrays.copyOf(result[inIdx], to);
        return result;
    }

    @UserFunction(value="apoc.nodes.isDense")
    @Description(value="Returns true if the given `NODE` is a dense node.")
    public boolean isDense(@Name(value="node", description="The node to check for being dense or not.") Node node) {
        try (NodeCursor nodeCursor = this.ktx.cursors().allocateNodeCursor(this.ktx.cursorContext());){
            long id = ((InternalTransaction)this.tx).elementIdMapper().nodeId(node.getElementId());
            this.ktx.dataRead().singleNode(id, nodeCursor);
            if (nodeCursor.next()) {
                boolean bl = nodeCursor.supportsFastDegreeLookup();
                return bl;
            }
            throw new IllegalArgumentException("node with id " + id + " does not exist.");
        }
    }
}

