/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class LabelMatcher {
    private List<String> labels = new ArrayList<String>();
    private List<List<String>> compoundLabels;
    private static LabelMatcher ACCEPTS_ALL_LABEL_MATCHER = new LabelMatcher(){

        @Override
        public boolean matchesLabels(Set<String> nodeLabels) {
            return true;
        }

        @Override
        public LabelMatcher addLabel(String label) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    };

    public LabelMatcher addLabel(String label) {
        String[] elements;
        if ("*".equals(label)) {
            return ACCEPTS_ALL_LABEL_MATCHER;
        }
        if (label.charAt(0) == ':') {
            label = label.substring(1);
        }
        if ((elements = label.split("(?<!\\\\):")).length == 1) {
            label = this.sanitizeLabel(label);
            this.labels.add(label);
        } else if (elements.length > 1) {
            if (this.compoundLabels == null) {
                this.compoundLabels = new ArrayList<List<String>>();
            }
            List<String> elementsList = Arrays.stream(elements).map(this::sanitizeLabel).toList();
            this.compoundLabels.add(elementsList);
        }
        return this;
    }

    private String sanitizeLabel(String label) {
        return label.replaceAll("\\\\:", ":");
    }

    public boolean matchesLabels(Set<String> nodeLabels) {
        for (String string : this.labels) {
            if (!nodeLabels.contains(string)) continue;
            return true;
        }
        if (this.compoundLabels != null) {
            for (List list : this.compoundLabels) {
                if (!nodeLabels.containsAll(list)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty() && (this.compoundLabels == null || this.compoundLabels.isEmpty());
    }
}

