/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.path.RelationshipTypeAndDirections;
import apoc.util.collection.Iterables;
import apoc.util.collection.Iterators;
import apoc.util.collection.NestingResourceIterator;
import apoc.util.collection.ResourceClosingIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;

public class RelationshipSequenceExpander
implements PathExpander {
    private final List<List<Pair<RelationshipType, Direction>>> relSequences = new ArrayList<List<Pair<RelationshipType, Direction>>>();
    private List<Pair<RelationshipType, Direction>> initialRels = null;

    public RelationshipSequenceExpander(String relSequenceString, boolean beginSequenceAtStart) {
        int index = 0;
        for (String sequenceStep : relSequenceString.split(",")) {
            sequenceStep = sequenceStep.trim();
            List<Pair<RelationshipType, Direction>> relDirIterable = RelationshipTypeAndDirections.parse(sequenceStep);
            ArrayList<Pair<RelationshipType, Direction>> stepRels = new ArrayList<Pair<RelationshipType, Direction>>();
            for (Pair pair : relDirIterable) {
                stepRels.add(pair);
            }
            if (!beginSequenceAtStart && index == 0) {
                this.initialRels = stepRels;
            } else {
                this.relSequences.add(stepRels);
            }
            ++index;
        }
    }

    public RelationshipSequenceExpander(List<String> relSequenceList, boolean beginSequenceAtStart) {
        int index = 0;
        for (String sequenceStep : relSequenceList) {
            sequenceStep = sequenceStep.trim();
            List<Pair<RelationshipType, Direction>> relDirIterable = RelationshipTypeAndDirections.parse(sequenceStep);
            ArrayList<Pair<RelationshipType, Direction>> stepRels = new ArrayList<Pair<RelationshipType, Direction>>();
            for (Pair pair : relDirIterable) {
                stepRels.add(pair);
            }
            if (!beginSequenceAtStart && index == 0) {
                this.initialRels = stepRels;
            } else {
                this.relSequences.add(stepRels);
            }
            ++index;
        }
    }

    public ResourceIterable<Relationship> expand(Path path, BranchState state) {
        final Node node = path.endNode();
        int depth = path.length();
        List<Pair<RelationshipType, Direction>> stepRels = depth == 0 && this.initialRels != null ? this.initialRels : this.relSequences.get((this.initialRels == null ? depth : depth - 1) % this.relSequences.size());
        return Iterables.asResourceIterable(Iterators.asList(new NestingResourceIterator<Relationship, Pair<RelationshipType, Direction>>(this, stepRels.iterator()){

            @Override
            protected ResourceIterator<Relationship> createNestedIterator(Pair<RelationshipType, Direction> entry) {
                RelationshipType type = entry.getLeft();
                Direction dir = entry.getRight();
                ResourceIterable relationships1 = type == null ? (dir == Direction.BOTH ? node.getRelationships() : node.getRelationships(dir)) : (dir == Direction.BOTH ? node.getRelationships(new RelationshipType[]{type}) : node.getRelationships(dir, new RelationshipType[]{type}));
                return ResourceClosingIterator.fromResourceIterable(relationships1);
            }
        }));
    }

    public PathExpander reverse() {
        throw new RuntimeException("Not implemented");
    }
}

