/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor.util;

import apoc.refactor.util.PropertiesManager;
import apoc.refactor.util.RefactorConfig;
import apoc.util.Util;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class RefactorUtil {
    public static void mergeRelationshipsWithSameTypeAndDirection(Node node, RefactorConfig config, Direction dir, List<String> excludeRelIds) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            StreamSupport.stream(node.getRelationships(dir, new RelationshipType[]{type}).spliterator(), false).filter(rel -> !excludeRelIds.contains(rel.getElementId())).collect(Collectors.groupingBy(rel -> Pair.of(rel.getStartNode(), rel.getEndNode()))).values().stream().filter(list -> !list.isEmpty()).forEach(list -> {
                Relationship first = (Relationship)list.get(0);
                if (Util.isSelfRel(first) && !config.isCreatingNewSelfRel()) {
                    list.forEach(Entity::delete);
                } else {
                    for (int i = 1; i < list.size(); ++i) {
                        Relationship relationship = (Relationship)list.get(i);
                        RefactorUtil.mergeRels(relationship, first, true, config);
                    }
                }
            });
        }
    }

    public static void mergeRels(Relationship source, Relationship target, boolean delete, RefactorConfig conf) {
        Map properties = source.getAllProperties();
        if (delete) {
            source.delete();
        }
        PropertiesManager.mergeProperties(properties, (Entity)target, conf);
    }

    public static <T extends Entity> T copyProperties(Entity source, T target) {
        return RefactorUtil.copyProperties(source.getAllProperties(), target);
    }

    public static <T extends Entity> T copyProperties(Map<String, Object> source, T target) {
        for (Map.Entry<String, Object> prop : source.entrySet()) {
            target.setProperty(prop.getKey(), prop.getValue());
        }
        return target;
    }
}

