/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import java.util.Arrays;
import java.util.List;
import org.neo4j.procedure.Description;

public class AssertSchemaResult {
    @Description(value="The label associated with the constraint or index.")
    public final Object label;
    @Description(value="The property key associated with the constraint or index.")
    public final String key;
    @Description(value="The property keys associated with the constraint or index.")
    public final List<String> keys;
    @Description(value="Whether or not this is a uniqueness constraint.")
    public boolean unique = false;
    @Description(value="The action applied to this constraint or index; can be [\"KEPT\", \"CREATED\", \"DROPPED\"]")
    public String action = "KEPT";

    public AssertSchemaResult(Object label, List<String> keys) {
        this.label = label;
        if (keys.size() == 1) {
            this.key = keys.get(0);
            this.keys = keys;
        } else {
            this.keys = keys;
            this.key = null;
        }
    }

    public AssertSchemaResult(String label, String key) {
        this.label = label;
        this.keys = Arrays.asList(key);
        this.key = key;
    }

    public AssertSchemaResult unique() {
        this.unique = true;
        return this;
    }

    public AssertSchemaResult dropped() {
        this.action = "DROPPED";
        return this;
    }

    public AssertSchemaResult created() {
        this.action = "CREATED";
        return this;
    }
}

