/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.result.VirtualRelationship;
import apoc.util.Util;
import apoc.util.collection.FilteringIterable;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;

public class VirtualNode
implements Node {
    public static final String ERROR_NODE_NULL = "The inserted Node is null";
    private static AtomicLong MIN_ID = new AtomicLong(-1L);
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final List<Relationship> rels = new ArrayList<Relationship>();
    private final long id;
    private final String elementId;

    public VirtualNode(Label[] labels, Map<String, Object> props) {
        this.id = MIN_ID.decrementAndGet();
        this.addLabels(Arrays.asList(labels));
        this.props.putAll(props);
        this.elementId = null;
    }

    public VirtualNode(long nodeId, Label[] labels, Map<String, Object> props) {
        this.id = nodeId;
        this.addLabels(Arrays.asList(labels));
        this.props.putAll(props);
        this.elementId = null;
    }

    public VirtualNode(long nodeId, String elementId, Label[] labels, Map<String, Object> props) {
        this.id = nodeId;
        this.elementId = elementId;
        this.addLabels(Arrays.asList(labels));
        this.props.putAll(props);
    }

    public VirtualNode(long nodeId) {
        this.id = nodeId;
        this.elementId = null;
    }

    public VirtualNode(Node node, List<String> propertyNames, boolean wrapNodeIDs) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        long id = node.getId();
        this.id = id < 0L || wrapNodeIDs ? id : MIN_ID.decrementAndGet();
        this.labels.addAll(Util.labelStrings(node));
        String[] keys = propertyNames.toArray(new String[propertyNames.size()]);
        this.props.putAll(node.getProperties(keys));
        this.elementId = node.getElementId();
    }

    public VirtualNode(Node node, List<String> propertyNames) {
        this(node, propertyNames, false);
    }

    public static VirtualNode from(Node node) {
        return new VirtualNode(node, Iterables.asList(node.getPropertyKeys()));
    }

    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return this.elementId != null ? this.elementId : String.valueOf(this.id);
    }

    public void delete() {
        for (Relationship rel : this.rels) {
            rel.delete();
        }
    }

    public ResourceIterable<Relationship> getRelationships() {
        return Iterables.asResourceIterable(this.rels);
    }

    public boolean hasRelationship() {
        return !this.rels.isEmpty();
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... relationshipTypes) {
        return Iterables.asResourceIterable(new FilteringIterable<Relationship>(this.rels, r -> this.isType((Relationship)r, relationshipTypes)));
    }

    private boolean isType(Relationship r, RelationshipType ... relationshipTypes) {
        for (RelationshipType type : relationshipTypes) {
            if (!r.isType(type)) continue;
            return true;
        }
        return false;
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... relationshipTypes) {
        return Iterables.asResourceIterable(new FilteringIterable<Relationship>(this.rels, r -> this.isType((Relationship)r, relationshipTypes) && this.isDirection((Relationship)r, direction)));
    }

    private boolean isDirection(Relationship r, Direction direction) {
        return direction == Direction.BOTH || direction == Direction.OUTGOING && r.getStartNode().equals((Object)this) || direction == Direction.INCOMING && r.getEndNode().equals((Object)this);
    }

    public boolean hasRelationship(RelationshipType ... relationshipTypes) {
        return this.getRelationships(relationshipTypes).iterator().hasNext();
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... relationshipTypes) {
        return this.getRelationships(direction, relationshipTypes).iterator().hasNext();
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction) {
        return Iterables.asResourceIterable(new FilteringIterable<Relationship>(this.rels, r -> this.isDirection((Relationship)r, direction)));
    }

    public boolean hasRelationship(Direction direction) {
        return this.getRelationships(direction).iterator().hasNext();
    }

    public Relationship getSingleRelationship(RelationshipType relationshipType, Direction direction) {
        return Iterables.single(this.getRelationships(direction, relationshipType));
    }

    public VirtualRelationship createRelationshipTo(Node node, RelationshipType relationshipType) {
        VirtualRelationship rel = new VirtualRelationship(this, node, relationshipType);
        this.rels.add(rel);
        if (node instanceof VirtualNode) {
            VirtualNode target = (VirtualNode)node;
            if (!target.rels.contains(rel)) {
                target.rels.add(rel);
            }
        }
        return rel;
    }

    public VirtualRelationship createRelationshipFrom(Node start, RelationshipType relationshipType) {
        VirtualRelationship rel = new VirtualRelationship(start, this, relationshipType);
        this.rels.add(rel);
        if (start instanceof VirtualNode) {
            VirtualNode startVirtual = (VirtualNode)start;
            if (!startVirtual.rels.contains(rel)) {
                startVirtual.rels.add(rel);
            }
        }
        return rel;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.rels.stream().map(Relationship::getType).collect(Collectors.toList());
    }

    public int getDegree() {
        return this.rels.size();
    }

    public int getDegree(RelationshipType relationshipType) {
        return (int)Iterables.count(this.getRelationships(relationshipType));
    }

    public int getDegree(Direction direction) {
        return (int)Iterables.count(this.getRelationships(direction));
    }

    public int getDegree(RelationshipType relationshipType, Direction direction) {
        return (int)Iterables.count(this.getRelationships(direction, relationshipType));
    }

    public void addLabel(Label label) {
        this.labels.add(label.name());
    }

    public void addLabels(Iterable<Label> labels) {
        for (Label label : labels) {
            this.addLabel(label);
        }
    }

    public void removeLabel(Label label) {
        this.labels.remove(label.name());
    }

    public boolean hasLabel(Label label) {
        return this.labels.contains(label.name());
    }

    public Iterable<Label> getLabels() {
        return this.labels.stream().map(Label::label).collect(Collectors.toList());
    }

    public boolean hasProperty(String s) {
        return this.props.containsKey(s);
    }

    public Object getProperty(String s) {
        return this.props.get(s);
    }

    public Object getProperty(String s, Object o) {
        Object value = this.props.get(s);
        return value == null ? o : value;
    }

    public void setProperty(String s, Object o) {
        this.props.put(s, o);
    }

    public Object removeProperty(String s) {
        return this.props.remove(s);
    }

    public Iterable<String> getPropertyKeys() {
        return this.props.keySet();
    }

    public Map<String, Object> getProperties(String ... strings) {
        HashMap<String, Object> res = new HashMap<String, Object>(this.props);
        res.keySet().retainAll(Arrays.asList(strings));
        return res;
    }

    public Map<String, Object> getAllProperties() {
        return this.props;
    }

    void delete(Relationship rel) {
        this.rels.remove(rel);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Node && Objects.equals(this.getElementId(), ((Node)o).getElementId());
    }

    public int hashCode() {
        return Objects.hashCode(this.elementId);
    }

    public String toString() {
        return "VirtualNode{id=" + this.id + ", labels=" + String.valueOf(this.labels) + ", props=" + String.valueOf(this.props) + ", rels=" + String.valueOf(this.rels) + "}";
    }
}

