/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.procedure.Description;

public class WeightedPathResult {
    @Description(value="The path result.")
    public Path path;
    @Description(value="The weight of the given path.")
    public double weight;

    public WeightedPathResult(WeightedPath weightedPath) {
        this.path = weightedPath;
        this.weight = weightedPath.weight();
    }

    public static Stream<WeightedPathResult> streamWeightedPathResult(Node startNode, Node endNode, PathFinder<WeightedPath> algo) {
        Iterable allPaths = algo.findAllPaths(startNode, endNode);
        return StreamSupport.stream(allPaths.spliterator(), false).map(WeightedPathResult::new);
    }
}

