/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SchemaConfig {
    private static final String LABELS_KEY = "labels";
    private static final String EXCLUDE_LABELS_KEY = "excludeLabels";
    private static final String RELATIONSHIPS_KEY = "relationships";
    private static final String EXCLUDE_RELATIONSHIPS_KEY = "excludeRelationships";
    private final Set<String> labels;
    private final Set<String> excludeLabels;
    private final Set<String> relationships;
    private final Set<String> excludeRelationships;

    public Set<String> getLabels() {
        return this.labels;
    }

    public Set<String> getExcludeLabels() {
        return this.excludeLabels;
    }

    public Set<String> getRelationships() {
        return this.relationships;
    }

    public Set<String> getExcludeRelationships() {
        return this.excludeRelationships;
    }

    public SchemaConfig(Map<String, Object> config) {
        config = config != null ? config : Collections.emptyMap();
        this.labels = new HashSet<String>((Collection)config.getOrDefault(LABELS_KEY, Collections.EMPTY_SET));
        this.excludeLabels = new HashSet<String>((Collection)config.getOrDefault(EXCLUDE_LABELS_KEY, Collections.EMPTY_SET));
        this.validateParameters(this.labels, this.excludeLabels, LABELS_KEY, EXCLUDE_LABELS_KEY);
        this.relationships = new HashSet<String>((Collection)config.getOrDefault(RELATIONSHIPS_KEY, Collections.EMPTY_SET));
        this.excludeRelationships = new HashSet<String>((Collection)config.getOrDefault(EXCLUDE_RELATIONSHIPS_KEY, Collections.EMPTY_SET));
        this.validateParameters(this.relationships, this.excludeRelationships, RELATIONSHIPS_KEY, EXCLUDE_RELATIONSHIPS_KEY);
    }

    private void validateParameters(Set<String> include, Set<String> exclude, String includeParameterType, String excludeParameterType) {
        if (!include.isEmpty() && !exclude.isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameters %s and %s are both valuated. Please check parameters and valuate only one.", includeParameterType, excludeParameterType));
        }
    }
}

