/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import apoc.result.AssertSchemaResult;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Schemas {
    @Context
    public Transaction tx;
    @Context
    public ProcedureCallContext procedureCallContext;

    @NotThreadSafe
    @Procedure(name="apoc.schema.assert", mode=Mode.SCHEMA)
    @Description(value="Drops all other existing indexes and constraints when `dropExisting` is `true` (default is `true`).\nAsserts at the end of the operation that the given indexes and unique constraints are there.")
    public Stream<AssertSchemaResult> schemaAssert(@Name(value="indexes", description="A map that pairs labels with lists of properties to create indexes from.") Map<String, List<Object>> indexes, @Name(value="constraints", description="A map that pairs labels with lists of properties to create constraints from.") Map<String, List<Object>> constraints, @Name(value="dropExisting", defaultValue="true", description="Whether or not to drop all other existing indexes and constraints.") boolean dropExisting) {
        return Stream.concat(this.assertIndexes(indexes, dropExisting, Util.getCypherVersionString(this.procedureCallContext)).stream(), this.assertConstraints(constraints, dropExisting).stream());
    }

    @NotThreadSafe
    @UserFunction(name="apoc.schema.node.indexExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not an index exists for the given `NODE` label with the given property names.")
    public Boolean indexExistsOnNode(@Name(value="labelName", description="The node label to check for an index on.") String labelName, @Name(value="propertyName", description="The property names to check for an index on.") List<String> propertyNames) {
        return this.indexExists(labelName, propertyNames);
    }

    @NotThreadSafe
    @UserFunction(value="apoc.schema.relationship.indexExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not an index exists for the given `RELATIONSHIP` type with the given property names.")
    public Boolean indexExistsOnRelationship(@Name(value="type", description="The relationship type to check for an index on.") String relName, @Name(value="propertyName", description="The property names to check for an index on.") List<String> propertyNames) {
        return this.indexExistsForRelationship(relName, propertyNames);
    }

    @NotThreadSafe
    @UserFunction(name="apoc.schema.node.constraintExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not a constraint exists for the given `NODE` label with the given property names.")
    public Boolean constraintExistsOnNode(@Name(value="labelName", description="The node label to check for a constraint on.") String labelName, @Name(value="propertyName", description="The property names to check for a constraint on.") List<String> propertyNames) {
        return this.constraintsExists(labelName, propertyNames);
    }

    @NotThreadSafe
    @UserFunction(name="apoc.schema.relationship.constraintExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not a constraint exists for the given `RELATIONSHIP` type with the given property names.")
    public Boolean constraintExistsOnRelationship(@Name(value="type", description="The relationship type to check for a constraint on.") String type, @Name(value="propertyName", description="The property names to check for a constraint on.") List<String> propertyNames) {
        return this.constraintsExistsForRelationship(type, propertyNames);
    }

    public List<AssertSchemaResult> assertConstraints(Map<String, List<Object>> constraints0, boolean dropExisting) {
        Map<String, List<Object>> constraints = this.copyMapOfObjects(constraints0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(constraints.size());
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : schema.getConstraints()) {
            ConstraintType constraintType = constraintDefinition.getConstraintType();
            String label = Util.isRelationshipCategory(constraintType) ? constraintDefinition.getRelationshipType().name() : constraintDefinition.getLabel().name();
            AssertSchemaResult info = new AssertSchemaResult((Object)label, Iterables.asList(constraintDefinition.getPropertyKeys()));
            if (Util.constraintIsUnique(constraintType)) {
                info = info.unique();
            }
            if (!this.checkIfConstraintExists(label, constraints, info) && dropExisting) {
                constraintDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        for (Map.Entry entry : constraints.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createUniqueConstraint(schema, (String)entry.getKey(), key.toString()));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createNodeKeyConstraint((String)entry.getKey(), (List)key));
            }
        }
        return result;
    }

    private boolean checkIfConstraintExists(String label, Map<String, List<Object>> constraints, AssertSchemaResult info) {
        if (constraints.containsKey(label)) {
            return constraints.get(label).removeIf(item -> {
                if (item instanceof String) {
                    return item.equals(info.key);
                }
                return info.keys.equals(item);
            });
        }
        return false;
    }

    private AssertSchemaResult createNodeKeyConstraint(String lbl, List<Object> keys) {
        String keyProperties = keys.stream().map(property -> String.format("n.`%s`", Util.sanitize(property.toString()))).collect(Collectors.joining(","));
        this.tx.execute(String.format("CREATE CONSTRAINT FOR (n:`%s`) REQUIRE (%s) IS NODE KEY", Util.sanitize(lbl), keyProperties)).close();
        List<String> keysToSting = keys.stream().map(Object::toString).collect(Collectors.toList());
        return new AssertSchemaResult((Object)lbl, keysToSting).unique().created();
    }

    private AssertSchemaResult createUniqueConstraint(Schema schema, String lbl, String key) {
        schema.constraintFor(Label.label((String)lbl)).assertPropertyIsUnique(key).create();
        return new AssertSchemaResult(lbl, key).unique().created();
    }

    public List<AssertSchemaResult> assertIndexes(Map<String, List<Object>> indexes0, boolean dropExisting, String cypherVersion) throws IllegalArgumentException {
        Schema schema = this.tx.schema();
        Map<String, List<Object>> indexes = this.copyMapOfObjects(indexes0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(indexes.size());
        for (IndexDefinition indexDefinition : Util.getIndexes(this.tx)) {
            if (indexDefinition.getIndexType() == IndexType.LOOKUP || indexDefinition.isConstraintIndex() || indexDefinition.isMultiTokenIndex()) continue;
            Object label = this.getLabelForAssert(indexDefinition, indexDefinition.isNodeIndex());
            ArrayList<String> keys = new ArrayList<String>();
            indexDefinition.getPropertyKeys().forEach(keys::add);
            AssertSchemaResult info = new AssertSchemaResult(label, keys);
            boolean included = Optional.ofNullable(indexes.get(label)).map(lbl -> {
                if (keys.size() > 1) {
                    return lbl.remove(keys);
                }
                if (keys.size() == 1) {
                    return lbl.remove(keys.get(0));
                }
                throw new IllegalArgumentException("Label given with no keys.");
            }).orElse(false);
            if (dropExisting && !included) {
                indexDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        for (Map.Entry entry : indexes.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createSinglePropertyIndex(schema, (String)entry.getKey(), (String)key));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createCompoundIndex((String)entry.getKey(), (List)key, cypherVersion));
            }
        }
        return result;
    }

    private Object getLabelForAssert(IndexDefinition definition, boolean nodeIndex) {
        if (nodeIndex) {
            return definition.isMultiTokenIndex() ? Iterables.stream(definition.getLabels()).map(Label::name).collect(Collectors.toList()) : ((Label)Iterables.single(definition.getLabels())).name();
        }
        return definition.isMultiTokenIndex() ? Iterables.stream(definition.getRelationshipTypes()).map(RelationshipType::name).collect(Collectors.toList()) : ((RelationshipType)Iterables.single(definition.getRelationshipTypes())).name();
    }

    private AssertSchemaResult createSinglePropertyIndex(Schema schema, String lbl, String key) {
        schema.indexFor(Label.label((String)lbl)).on(key).create();
        return new AssertSchemaResult(lbl, key).created();
    }

    private AssertSchemaResult createCompoundIndex(String label, List<String> keys, String cypherVersion) {
        ArrayList backTickedKeys = new ArrayList();
        keys.forEach(key -> backTickedKeys.add(String.format("n.`%s`", Util.sanitize(key))));
        this.tx.execute(String.format("CYPHER %s CREATE INDEX FOR (n:`%s`) ON (%s)", cypherVersion, Util.sanitize(label), String.join((CharSequence)",", backTickedKeys))).close();
        return new AssertSchemaResult((Object)label, keys).created();
    }

    private Map<String, List<Object>> copyMapOfObjects(Map<String, List<Object>> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(input.size());
        input.forEach((k, v) -> result.put((String)k, new ArrayList(v)));
        return result;
    }

    private Boolean indexExists(String labelName, List<String> propertyNames) {
        Iterable<IndexDefinition> nodeIndexes = Util.getIndexes(this.tx, Label.label((String)labelName));
        return this.isIndexExistent(propertyNames, nodeIndexes);
    }

    private Boolean indexExistsForRelationship(String relName, List<String> propertyNames) {
        Iterable<IndexDefinition> relIndexes = Util.getIndexes(this.tx, RelationshipType.withName((String)relName));
        return this.isIndexExistent(propertyNames, relIndexes);
    }

    private Boolean isIndexExistent(List<String> propertyNames, Iterable<IndexDefinition> indexes) {
        for (IndexDefinition indexDefinition : indexes) {
            List properties = Iterables.asList(indexDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExists(String labelName, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList(schema.getConstraints(Label.label((String)labelName)))) {
            List properties = Iterables.asList(constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExistsForRelationship(String type, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList(schema.getConstraints(RelationshipType.withName((String)type)))) {
            List properties = Iterables.asList(constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }
}

