/*
 * Decompiled with CFR 0.152.
 */
package apoc.scoring;

import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Scoring {
    @UserFunction(value="apoc.scoring.existence")
    @Description(value="Returns the given score if true, 0 if false.")
    public double existence(@Name(value="score", description="The score to return if the exists is true.") long score, @Name(value="exists", description="Whether or not to return the score.") boolean exists) {
        return exists ? score : 0L;
    }

    @UserFunction(value="apoc.scoring.pareto")
    @Description(value="Applies a Pareto scoring function over the given `INTEGER` values.")
    public double pareto(@Name(value="minimumThreshold", description="The minimum threshold for the score.") long minimumThreshold, @Name(value="eightyPercentValue", description="The eighty percent value.") long eightyPercentValue, @Name(value="maximumValue", description="The maximum value.") long maximumValue, @Name(value="score", description="The score.") long score) {
        if (score < minimumThreshold) {
            return 0.0;
        }
        double alpha = Math.log(5.0) / (double)eightyPercentValue;
        double exp = Math.exp(-alpha * (double)score);
        return (double)maximumValue * (1.0 - exp);
    }
}

