/*
 * Decompiled with CFR 0.152.
 */
package apoc.text;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Soundex;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Phonetic {
    private static final DoubleMetaphone DOUBLE_METAPHONE = new DoubleMetaphone();

    @UserFunction(value="apoc.text.phonetic")
    @Description(value="Returns the US_ENGLISH phonetic soundex encoding of all words of the `STRING`.")
    public String phonetic(@Name(value="text", description="The string to encode using US_ENGLISH phonetic soundex.") String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(value.split("\\W+")).map(arg_0 -> ((Soundex)Soundex.US_ENGLISH).soundex(arg_0)).collect(Collectors.joining(""));
    }

    @Procedure(value="apoc.text.phoneticDelta")
    @Description(value="Returns the US_ENGLISH soundex character difference between the two given `STRING` values.")
    public Stream<PhoneticResult> phoneticDelta(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        try {
            return Stream.of(new PhoneticResult(Soundex.US_ENGLISH.soundex(text1), Soundex.US_ENGLISH.soundex(text2), Soundex.US_ENGLISH.difference(text1, text2)));
        }
        catch (EncoderException e) {
            throw new RuntimeException("Error encoding text " + text1 + " or " + text2 + " for delta measure", e);
        }
    }

    @UserFunction(value="apoc.text.doubleMetaphone")
    @Description(value="Returns the double metaphone phonetic encoding of all words in the given `STRING` value.")
    public String doubleMetaphone(@Name(value="value", description="The string to be encoded using the double metaphone phonetic encoding.") String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        return Stream.of(value.split("\\W+")).map(arg_0 -> ((DoubleMetaphone)DOUBLE_METAPHONE).doubleMetaphone(arg_0)).collect(Collectors.joining(""));
    }

    public static class PhoneticResult {
        @Description(value="The phonetic representation of the first string.")
        public final String phonetic1;
        @Description(value="The phonetic representation of the second string.")
        public final String phonetic2;
        @Description(value="The soundex character difference between the two given strings.")
        public final long delta;

        public PhoneticResult(String phonetic1, String phonetic2, Number delta) {
            this.phonetic1 = phonetic1;
            this.phonetic2 = phonetic2;
            this.delta = delta.longValue();
        }
    }
}

