/*
 * Decompiled with CFR 0.152.
 */
package apoc.text;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SorensenDiceCoefficient {
    private static final double HIGHEST_SCORE = 1.0;

    public static double compute(String input1, String input2) {
        return SorensenDiceCoefficient.compute(input1, input2, Locale.ENGLISH);
    }

    public static double compute(String input1, String input2, String languageTag) {
        return SorensenDiceCoefficient.compute(input1, input2, Locale.forLanguageTag(languageTag));
    }

    private static double compute(String input1, String input2, Locale locale) {
        List<String> words2;
        if (input1.equals(input2)) {
            return 1.0;
        }
        List<String> words1 = SorensenDiceCoefficient.normalizedWords(input1, locale);
        if (words1.equals(words2 = SorensenDiceCoefficient.normalizedWords(input2, locale))) {
            return 1.0;
        }
        List<Bigram> bigrams1 = SorensenDiceCoefficient.allSortedBigrams(words1);
        List<Bigram> bigrams2 = SorensenDiceCoefficient.allSortedBigrams(words2);
        int index1 = 0;
        int index2 = 0;
        int matches = 0;
        while (index1 < bigrams1.size() && index2 < bigrams2.size()) {
            Bigram bigram2;
            Bigram bigram1 = bigrams1.get(index1);
            if (bigram1.equals(bigram2 = bigrams2.get(index2))) {
                ++matches;
                ++index1;
                ++index2;
                continue;
            }
            if (bigram1.lessThan(bigram2)) {
                ++index1;
                continue;
            }
            ++index2;
        }
        return 2.0 * (double)matches / (double)(bigrams1.size() + bigrams2.size());
    }

    private static List<Bigram> allSortedBigrams(List<String> words) {
        return words.stream().flatMap(s -> SorensenDiceCoefficient.toStream(s.toCharArray())).sorted().collect(Collectors.toList());
    }

    private static Stream<Bigram> toStream(char[] chars) {
        return IntStream.range(0, chars.length - 1).mapToObj(i -> new Bigram(chars[i], chars[i + 1]));
    }

    private static List<String> normalizedWords(String text1, Locale locale) {
        return Arrays.asList(text1.trim().toUpperCase(locale).split("\\s+"));
    }

    private static class Bigram
    implements Comparable<Bigram> {
        private final char first;
        private final char second;

        public Bigram(char first, char second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.first), Character.valueOf(this.second));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bigram other = (Bigram)obj;
            return Objects.equals(Character.valueOf(this.first), Character.valueOf(other.first)) && Objects.equals(Character.valueOf(this.second), Character.valueOf(other.second));
        }

        public boolean lessThan(Bigram other) {
            if (this.first < other.first) {
                return true;
            }
            return this.first == other.first && this.second < other.second;
        }

        public String toString() {
            return String.format("[%c,%c]", Character.valueOf(this.first), Character.valueOf(this.second));
        }

        @Override
        public int compareTo(Bigram other) {
            if (this == other) {
                return 0;
            }
            if (this.first == other.first && this.second == other.second) {
                return 0;
            }
            if (this.lessThan(other)) {
                return -1;
            }
            return 1;
        }
    }
}

