/*
 * Decompiled with CFR 0.152.
 */
package apoc.text;

import apoc.text.SorensenDiceCoefficient;
import apoc.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.similarity.HammingDistance;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Strings {
    private static final HammingDistance hammingDistance = new HammingDistance();
    private static final JaroWinklerDistance jaroWinklerDistance = new JaroWinklerDistance();
    private static final LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
    @Context
    public Transaction tx;
    private static Pattern cleanPattern = Pattern.compile("[^\\p{L}\\p{N}]+");
    private static Pattern specialCharPattern = Pattern.compile("\\p{IsM}+");
    private static String[][] UMLAUT_REPLACEMENTS = new String[][]{{new String("\u00c4"), "Ae"}, {new String("\u00dc"), "Ue"}, {new String("\u00d6"), "Oe"}, {new String("\u00e4"), "ae"}, {new String("\u00fc"), "ue"}, {new String("\u00f6"), "oe"}, {new String("\u00df"), "ss"}};
    private static final String lower = "abcdefghijklmnopqrstuvwxyz";
    private static final String upper = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String numeric = "0123456789";

    @UserFunction(value="apoc.text.indexOf")
    @Description(value="Returns the first occurrence of the lookup `STRING` in the given `STRING`, or -1 if not found.")
    public Long indexOf(@Name(value="text", description="The string to search for the lookup string in.") String text, @Name(value="lookup", description="The lookup string to search for in the given string.") String lookup, @Name(value="from", defaultValue="0", description="The index at which to start the search.") long from, @Name(value="to", defaultValue="-1", description="The index at which to stop the search.") long to) {
        if (text == null) {
            return null;
        }
        if (lookup == null) {
            return -1L;
        }
        if (to == -1L || to > (long)text.length()) {
            return text.indexOf(lookup, (int)from);
        }
        if (to <= from) {
            return -1L;
        }
        return text.substring(0, (int)to).indexOf(lookup, (int)from);
    }

    @UserFunction(value="apoc.text.indexesOf")
    @Description(value="Returns all occurrences of the lookup `STRING` in the given `STRING`, or an empty list if not found.")
    public List<Long> indexesOf(@Name(value="text", description="The string to search for the lookup string in.") String text, @Name(value="lookup", description="The lookup string to search for in the given string.") String lookup, @Name(value="from", defaultValue="0", description="The index at which to start the search.") long from, @Name(value="to", defaultValue="-1", description="The index at which to stop the search.") long to) {
        if (text == null) {
            return null;
        }
        if (lookup == null) {
            return Collections.emptyList();
        }
        if (to == -1L) {
            to = text.length();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        int idx = (int)from - 1;
        while ((idx = text.indexOf(lookup, idx + 1)) != -1 && (long)idx < to) {
            result.add(Long.valueOf(idx));
        }
        return result;
    }

    @UserFunction(value="apoc.text.replace")
    @Description(value="Finds and replaces all matches found by the given regular expression with the given replacement.")
    public String replace(@Name(value="text", description="The string to be modified.") String text, @Name(value="regex", description="The regular expression pattern to replace in the original string.") String regex, @Name(value="replacement", description="The value to be inserted in the original string.") String replacement) {
        return this.regreplace(text, regex, replacement);
    }

    @UserFunction(value="apoc.text.byteCount")
    @Description(value="Returns the size of the given `STRING` in bytes.")
    public long byteCount(@Name(value="text", description="The string to get the size of in bytes.") String text, @Name(value="charset", defaultValue="UTF-8", description="The name of a supported charset.") String charset) throws UnsupportedEncodingException {
        return text.getBytes(charset).length;
    }

    @UserFunction(value="apoc.text.bytes")
    @Description(value="Returns the given `STRING` as bytes.")
    public List<Long> bytes(@Name(value="text", description="The string to get the bytes from.") String text, @Name(value="charset", defaultValue="UTF-8", description="The name of a supported charset.") String charset) throws UnsupportedEncodingException {
        byte[] bytes = text.getBytes(charset);
        ArrayList<Long> result = new ArrayList<Long>(bytes.length);
        for (byte b : bytes) {
            result.add((long)b & 0xFFL);
        }
        return result;
    }

    @UserFunction(name="apoc.text.regreplace", deprecatedBy="apoc.text.replace")
    @Deprecated
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Finds and replaces all matches found by the given regular expression with the given replacement.")
    public String regreplace(@Name(value="text", description="The string to be modified.") String text, @Name(value="regex", description="The regular expression pattern to replace in the original string.") String regex, @Name(value="replacement", description="The value to be inserted in the original string.") String replacement) {
        if (text == null || regex == null || replacement == null) {
            return null;
        }
        return text.replaceAll(regex, replacement);
    }

    @UserFunction(value="apoc.text.split")
    @Description(value="Splits the given `STRING` using a given regular expression as a separator.")
    public List<String> split(@Name(value="text", description="The string to split.") String text, @Name(value="regex", description="The delimiting regular expression.") String regex, @Name(value="limit", defaultValue="0", description="The number of times the regex pattern is applied; if set to 0, it will be applied as many times as possible.") Long limit) {
        if (text == null || regex == null || limit == null) {
            return null;
        }
        String[] resultArray = text.split(regex, limit.intValue());
        return new ArrayList<String>(Arrays.asList(resultArray));
    }

    @UserFunction(value="apoc.text.regexGroups")
    @Description(value="Returns all groups matching the given regular expression in the given text.")
    public List<List<String>> regexGroups(@Name(value="text", description="The text to extract matches from.") String text, @Name(value="regex", description="The regex pattern to match.") String regex) {
        if (text == null || regex == null) {
            return Collections.EMPTY_LIST;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        while (matcher.find()) {
            ArrayList<String> matchResult = new ArrayList<String>();
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                matchResult.add(matcher.group(i));
            }
            result.add(matchResult);
        }
        return result;
    }

    @UserFunction(value="apoc.text.regexGroupsByName")
    @Description(value="Returns all groups with their group name matching the given regular expression in the given text.")
    public List<Map<String, Object>> regexGroupsByName(@Name(value="text", description="The text to extract matches from.") String text, @Name(value="regex", description="The regex pattern to match.") String regex) {
        if (text == null || regex == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            List<String> namedGroups = this.getNamedGroups(regex);
            while (matcher.find()) {
                HashMap<String, Object> matchGroupResult = new HashMap<String, Object>();
                matchGroupResult.put("group", matcher.group());
                HashMap<String, String> matches = new HashMap<String, String>();
                for (String groupName : namedGroups) {
                    String match = matcher.group(groupName);
                    if (match == null) continue;
                    matches.put(groupName, match);
                }
                matchGroupResult.put("matches", matches);
                result.add(matchGroupResult);
            }
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("Invalid regex pattern: " + e.getMessage());
        }
        return result;
    }

    private List<String> getNamedGroups(String text) {
        ArrayList<String> namedGroups = new ArrayList<String>();
        Matcher mG = Pattern.compile("\\(\\?<(.+?)>").matcher(text);
        while (mG.find()) {
            for (int i = 1; i <= mG.groupCount(); ++i) {
                namedGroups.add(mG.group(i));
            }
        }
        return namedGroups;
    }

    @UserFunction(value="apoc.text.join")
    @Description(value="Joins the given `STRING` values using the given delimiter.")
    public String join(@Name(value="texts", description="The list of strings to be concatenated using the given delimiter.") List<String> texts, @Name(value="delimiter", description="The given delimiter to join the given strings with.") String delimiter) {
        if (texts == null || delimiter == null) {
            return null;
        }
        return String.join((CharSequence)delimiter, texts);
    }

    @UserFunction(value="apoc.text.clean")
    @Description(value="Strips the given `STRING` of everything except alpha numeric characters and converts it to lower case.")
    public String clean(@Name(value="text", description="The string to be stripped of all non-alphanumeric characters and converted to lowercase.") String text) {
        return text == null ? null : Strings.removeNonWordCharacters(text);
    }

    @UserFunction(value="apoc.text.compareCleaned")
    @Description(value="Compares two given `STRING` values stripped of everything except alpha numeric characters converted to lower case.")
    public boolean compareCleaned(@Name(value="text1", description="The first string to be stripped of all non-alphanumeric characters and compared to the second string.") String text1, @Name(value="text2", description="The second string to be stripped of all non-alphanumeric characters and compared to the first string.") String text2) {
        if (text1 == null || text2 == null) {
            return false;
        }
        return Strings.removeNonWordCharacters(text1).equals(Strings.removeNonWordCharacters(text2));
    }

    @UserFunction(value="apoc.text.distance")
    @Description(value="Compares the two given `STRING` values using the Levenshtein distance algorithm.")
    public Long distance(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        return this.levenshteinDistance(text1, text2);
    }

    @UserFunction(name="apoc.text.levenshteinDistance", deprecatedBy="apoc.text.distance")
    @Deprecated
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Compares the given `STRING` values using the Levenshtein distance algorithm.")
    public Long levenshteinDistance(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        return (long)levenshteinDistance.apply(text1, text2);
    }

    @UserFunction(value="apoc.text.levenshteinSimilarity")
    @Description(value="Returns the similarity (a value within 0 and 1) between the two given `STRING` values based on the Levenshtein distance algorithm.")
    public Double levenshteinSimilarity(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        int longerLength = Math.max(text1.length(), text2.length());
        if (longerLength == 0) {
            return 1.0;
        }
        long editDistance = this.distance(text1, text2);
        return (double)((long)longerLength - editDistance) / (double)longerLength;
    }

    @UserFunction(value="apoc.text.hammingDistance")
    @Description(value="Compares the two given `STRING` values using the Hamming distance algorithm.")
    public Long hammingDistance(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        return (long)hammingDistance.apply(text1, text2);
    }

    @UserFunction(value="apoc.text.jaroWinklerDistance")
    @Description(value="Compares the two given `STRING` values using the Jaro-Winkler distance algorithm.")
    public Double jaroWinklerDistance(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        return jaroWinklerDistance.apply(text1, text2);
    }

    @UserFunction(value="apoc.text.sorensenDiceSimilarity")
    @Description(value="Compares the two given `STRING` values using the S\u00f8rensen\u2013Dice coefficient formula, with the provided IETF language tag.")
    public Double sorensenDiceSimilarity(@Name(value="text1", description="A string to be compared against `text2`.") String text1, @Name(value="text2", description="A string to be compared against `text1`.") String text2, @Name(value="languageTag", defaultValue="en", description="A language tag string specified by IETF BCP 47.") String languageTag) {
        if (text1 == null || text2 == null || languageTag == null) {
            return null;
        }
        return SorensenDiceCoefficient.compute(text1, text2, languageTag);
    }

    @UserFunction(value="apoc.text.fuzzyMatch")
    @Description(value="Performs a fuzzy match search of the two given `STRING` values.")
    public Boolean fuzzyMatch(@Name(value="text1", description="The first string to be compared against the second.") String text1, @Name(value="text2", description="The second string to be compared against the first.") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        int termLength = text1.length();
        int maxDistanceAllowed = termLength < 3 ? 0 : (termLength < 5 ? 1 : 2);
        Long distance = this.distance(text1, text2);
        return distance <= (long)maxDistanceAllowed;
    }

    @UserFunction(value="apoc.text.urlencode")
    @Description(value="Encodes the given URL `STRING`.")
    public String urlencode(@Name(value="text", description="The string to url encode.") String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("urlencoding failed", e);
        }
    }

    @UserFunction(value="apoc.text.urldecode")
    @Description(value="Decodes the given URL encoded `STRING`.")
    public String urldecode(@Name(value="text", description="The string to url decode.") String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("urldecoding failed", e);
        }
    }

    private static String removeNonWordCharacters(String s) {
        String result = s;
        for (int i = 0; i < UMLAUT_REPLACEMENTS.length; ++i) {
            result = result.replace(UMLAUT_REPLACEMENTS[i][0], UMLAUT_REPLACEMENTS[i][1]);
        }
        result = Normalizer.normalize(result, Normalizer.Form.NFD);
        String tmp2 = specialCharPattern.matcher(result).replaceAll("");
        return cleanPattern.matcher(tmp2).replaceAll("").toLowerCase();
    }

    @UserFunction(value="apoc.text.lpad")
    @Description(value="Left pads the given `STRING` by the given width.")
    public String lpad(@Name(value="text", description="The string to be padded.") String text, @Name(value="count", description="The number of delimiters to pad the given string with.") long count, @Name(value="delimiter", defaultValue=" ", description="The delimiter to pad the given string with.") String delim) {
        int len = text.length();
        if ((long)len >= count) {
            return text;
        }
        StringBuilder sb = new StringBuilder((int)count);
        char[] chars = new char[(int)count - len];
        Arrays.fill(chars, delim.charAt(0));
        sb.append(chars);
        sb.append(text);
        return sb.toString();
    }

    @UserFunction(value="apoc.text.rpad")
    @Description(value="Right pads the given `STRING` by the given width.")
    public String rpad(@Name(value="text", description="The string to be padded.") String text, @Name(value="count", description="The number of delimiters to pad the given string with.") long count, @Name(value="delimiter", defaultValue=" ", description="The delimiter to pad the given string with.") String delim) {
        int len = text.length();
        if ((long)len >= count) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        char[] chars = new char[(int)count - len];
        Arrays.fill(chars, delim.charAt(0));
        sb.append(chars);
        return sb.toString();
    }

    @UserFunction(value="apoc.text.format")
    @Description(value="Formats the given `STRING` with the given parameters.")
    public String format(@Name(value="text", description="The format string.") String text, @Name(value="params", description="Arguments referenced by the format specifiers in the format string.") List<Object> params, @Name(value="language", defaultValue="en", description="An ISO 639 alpha-2 or alpha-3 language code, or a language subtag up to 8 characters in length.") String lang) {
        if (text == null) {
            return null;
        }
        if (params == null) {
            return text;
        }
        return String.format(new Locale(lang), text, params.toArray());
    }

    @UserFunction(value="apoc.text.slug")
    @Description(value="Replaces the whitespace in the given `STRING` with the given delimiter.")
    public String slug(@Name(value="text", description="The string whose whitespace is to be replaced.") String text, @Name(value="delimiter", defaultValue="-", description="The delimiter to replace the whitespace with.") String delim) {
        if (text == null) {
            return null;
        }
        if (delim == null) {
            return null;
        }
        return text.trim().replaceAll("[^\\p{L}0-9_]+", delim);
    }

    @UserFunction(value="apoc.text.random")
    @Description(value="Generates a random `STRING` to the given length using a length parameter and an optional `STRING` of valid characters.\nUnsuitable for cryptographic use-cases.")
    public String random(@Name(value="length", description="The length of the random string.") long length, @Name(value="valid", defaultValue="A-Za-z0-9", description="The valid characters the random string can contain.") String valid) {
        valid = valid.replaceAll("A-Z", upper).replaceAll("a-z", lower).replaceAll("0-9", numeric);
        StringBuilder output = new StringBuilder(Math.toIntExact(length));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        while ((long)output.length() < length) {
            output.append(valid.charAt(rand.nextInt(valid.length())));
        }
        return output.toString();
    }

    @UserFunction(value="apoc.text.capitalize")
    @Description(value="Capitalizes the first letter of the given `STRING`.")
    public String capitalize(@Name(value="text", description="The string in which to capitalize the first letter.") String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    @UserFunction(value="apoc.text.capitalizeAll")
    @Description(value="Capitalizes the first letter of every word in the given `STRING`.")
    public String capitalizeAll(@Name(value="text", description="The string in which to capitalize every word.") String text) {
        String[] parts = text.split(" ");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            output.append(StringUtils.capitalize(part) + " ");
        }
        return output.toString().trim();
    }

    @UserFunction(value="apoc.text.decapitalize")
    @Description(value="Turns the first letter of the given `STRING` from upper case to lower case.")
    public String decapitalize(@Name(value="text", description="The string in which to decapitalize the first letter.") String text) {
        return StringUtils.uncapitalize(text);
    }

    @UserFunction(value="apoc.text.decapitalizeAll")
    @Description(value="Turns the first letter of every word in the given `STRING` to lower case.")
    public String decapitalizeAll(@Name(value="text", description="The string in which to decapitalize every word.") String text) {
        String[] parts = text.split(" ");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            output.append(StringUtils.uncapitalize(part) + " ");
        }
        return output.toString().trim();
    }

    @UserFunction(value="apoc.text.swapCase")
    @Description(value="Swaps the cases in the given `STRING`.")
    public String swapCase(@Name(value="text", description="The string to swap the case of.") String text) {
        return StringUtils.swapCase(text);
    }

    @UserFunction(value="apoc.text.camelCase")
    @Description(value="Converts the given `STRING` to camel case.")
    public String camelCase(@Name(value="text", description="The string to be converted to camel case.") String text) {
        text = text.replaceAll("[^\\p{L}0-9]|_", " ");
        String[] parts = text.split("(\\s+)");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            part = part.toLowerCase();
            output.append(StringUtils.capitalize(part));
        }
        return output.substring(0, 1).toLowerCase() + output.substring(1);
    }

    @UserFunction(value="apoc.text.upperCamelCase")
    @Description(value="Converts the given `STRING` to upper camel case.")
    public String upperCamelCase(@Name(value="text", description="The string to convert to camel case.") String text) {
        String output = this.camelCase(text);
        return output.substring(0, 1).toUpperCase() + output.substring(1);
    }

    @UserFunction(value="apoc.text.snakeCase")
    @Description(value="Converts the given `STRING` to snake case.")
    public String snakeCase(@Name(value="text", description="The string to convert to snake case.") String text) {
        if (text.matches("^([\\p{Lu}0-9_]+)$")) {
            text = text.toLowerCase().replace("_", " ");
        }
        String[] parts = text.split("(?=[^\\p{Ll}0-9])");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            if (output.length() > 0) {
                output.append("-");
            }
            output.append(part.toLowerCase().trim().replace("(^[\\p{Ll}0-9]+)", "-"));
        }
        return output.toString().toLowerCase().replaceAll("--", "-");
    }

    @UserFunction(value="apoc.text.toUpperCase")
    @Description(value="Converts the given `STRING` to upper case.")
    public String toUpperCase(@Name(value="text", description="The string to convert to upper case.") String text) {
        String[] parts = text.split("(?=[^a-z0-9]+)");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            if ((part = part.trim().toUpperCase().replaceAll("[^A-Z0-9]+", "")).length() <= 0) continue;
            if (output.length() > 0) {
                output.append("_");
            }
            output.append(part);
        }
        return output.toString();
    }

    @UserFunction(value="apoc.text.base64Encode")
    @Description(value="Encodes the given `STRING` with Base64.")
    public String base64Encode(@Name(value="text", description="The string to be encoded using base64.") String text) {
        byte[] encoded = Base64.getEncoder().encode(text.getBytes());
        return new String(encoded);
    }

    @UserFunction(value="apoc.text.base64Decode")
    @Description(value="Decodes the given Base64 encoded `STRING`.")
    public String base64Decode(@Name(value="text", description="The string to be decoded using base64.") String text) {
        byte[] decoded = Base64.getDecoder().decode(text.getBytes());
        return new String(decoded);
    }

    @UserFunction(value="apoc.text.base64UrlEncode")
    @Description(value="Encodes the given URL with Base64.")
    public String base64UrlEncode(@Name(value="url", description="The url to be encoded with base64.") String url) {
        byte[] encoded = Base64.getUrlEncoder().encode(url.getBytes());
        return new String(encoded);
    }

    @UserFunction(value="apoc.text.base64UrlDecode")
    @Description(value="Decodes the given Base64 encoded URL.")
    public String base64UrlDecode(@Name(value="url", description="The url to be decoded using base64.") String url) {
        byte[] decoded = Base64.getUrlDecoder().decode(url.getBytes());
        return new String(decoded);
    }

    @UserFunction(value="apoc.text.charAt")
    @Description(value="Returns the `INTEGER` value of the character at the given index.")
    public Long charAt(@Name(value="text", description="The string from which a character is taken to be converted into an integer value.") String text, @Name(value="index", description="The index of the character in the given string to convert.") Long index) {
        if (index == null || text == null || text.isEmpty() || index < 0L || index >= (long)text.length()) {
            return null;
        }
        return text.charAt(index.intValue());
    }

    @UserFunction(value="apoc.text.code")
    @Description(value="Converts the `INTEGER` value into a `STRING`.")
    public String code(@Name(value="codepoint", description="An integer to be converted into a character.") Long codepoint) {
        if (codepoint == null || codepoint < 0L || codepoint > 65535L) {
            return null;
        }
        return String.valueOf((char)codepoint.intValue());
    }

    @UserFunction(value="apoc.text.hexValue")
    @Description(value="Returns the hexadecimal value of the given value.")
    public String hexValue(@Name(value="value", description="The value to convert into a hexidecimal value represented as a string.") Long value) {
        if (value == null) {
            return null;
        }
        return value > 0xFFFFFFFFL ? String.format("%016X", value) : (value > 65535L ? String.format("%08X", value.intValue()) : String.format("%04X", value.intValue()));
    }

    @UserFunction(value="apoc.text.hexCharAt")
    @Description(value="Returns the hexadecimal value of the given `STRING` at the given index.")
    public String hexCharAt(@Name(value="text", description="The string from which to take a character and convert it into a hexadecimal value represented as a string") String text, @Name(value="index", description="The index of the character in the given string to convert.") Long index) {
        return this.hexValue(this.charAt(text, index));
    }

    private boolean isPrimitive(Object value) {
        return value == null || value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    private String cypherName(Map<String, Object> config, String key, Supplier<String> s, Function<String, String> quoter) {
        Object name = config.get(key);
        if (name != null) {
            return quoter.apply(name.toString());
        }
        return s.get();
    }

    @UserFunction(value="apoc.text.toCypher")
    @Description(value="Converts the given value to a Cypher property `STRING`.")
    public String toCypher(@Name(value="value", description="The value to convert to a Cypher property string.") Object value, @Name(value="config", defaultValue="{}", description="{ keepValues :: LIST<ANY> , skipValues :: LIST<ANY> }") Map<String, Object> config) {
        if (config.containsKey("keepValues") && !((Collection)config.get("keepValues")).stream().noneMatch(v -> (v.getClass().isInstance(value) || this.isPrimitive(value) && this.isPrimitive(v)) && !value.equals(v))) {
            return null;
        }
        if (config.containsKey("skipValues") && ((Collection)config.get("skipValues")).contains(value)) {
            return null;
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Iterable) {
            return "[" + StreamSupport.stream(((Iterable)value).spliterator(), false).map(v -> this.toCypher(v, config)).filter(Objects::nonNull).collect(Collectors.joining(",")) + "]";
        }
        if (value.getClass().isArray()) {
            return "[" + Arrays.stream((Object[])value).map(v -> this.toCypher(v, config)).filter(Objects::nonNull).collect(Collectors.joining(",")) + "]";
        }
        if (value instanceof Node) {
            Node node = Util.rebind(this.tx, (Node)value);
            Object labels = StreamSupport.stream(node.getLabels().spliterator(), false).map(l -> Util.quote(l.name())).collect(Collectors.joining(":"));
            if (!((String)labels).isEmpty()) {
                labels = ":" + (String)labels;
            }
            String var = this.cypherName(config, "node", () -> "", Util::quote);
            return "(" + var + (String)labels + " " + this.toCypher(node.getAllProperties(), config) + ")";
        }
        if (value instanceof Relationship) {
            Relationship rel = Util.rebind(this.tx, (Relationship)value);
            String type = ":" + Util.quote(rel.getType().name());
            String start = this.cypherName(config, "start", () -> this.toCypher(rel.getStartNode(), config), s -> "(" + Util.quote(s) + ")");
            String relationship = this.cypherName(config, "relationship", () -> "", Util::quote);
            String end = this.cypherName(config, "end", () -> this.toCypher(rel.getEndNode(), config), s -> "(" + Util.quote(s) + ")");
            return start + "-[" + relationship + type + " " + this.toCypher(rel.getAllProperties(), config) + "]->" + end;
        }
        if (value instanceof Map) {
            Map values = (Map)value;
            if (config.containsKey("keepKeys")) {
                values.keySet().retainAll((List)config.get("keepKeys"));
            }
            if (config.containsKey("skipKeys")) {
                values.keySet().removeAll((List)config.get("skipKeys"));
            }
            return "{" + values.entrySet().stream().map(e -> Pair.of((String)e.getKey(), this.toCypher(e.getValue(), config))).filter(p -> p.getRight() != null).sorted(Comparator.comparing(Pair::getLeft)).map(p -> Util.quote((String)p.getLeft()) + ":" + (String)p.getRight()).collect(Collectors.joining(",")) + "}";
        }
        return null;
    }

    @UserFunction(value="apoc.text.repeat")
    @Description(value="Returns the result of the given item multiplied by the given count.")
    public String repeat(@Name(value="item", description="The string to be repeated.") String item, @Name(value="count", description="The number of times to repeat the given string.") long count) {
        StringBuilder result = new StringBuilder((int)count * item.length());
        int i = 0;
        while ((long)i < count) {
            result.append(item);
            ++i;
        }
        return result.toString();
    }
}

