/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.CompressionAlgo;
import apoc.util.CompressionConfig;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.UserFunction;

public class Utils {
    @Context
    public TerminationGuard terminationGuard;

    @UserFunction(value="apoc.util.sha1")
    @Description(value="Returns the SHA1 of the concatenation of all `STRING` values in the given `LIST<ANY>`.\nSHA1 is a weak hashing algorithm which is unsuitable for cryptographic use-cases.")
    public String sha1(@Name(value="values", description="The list of values to concatenate and generate a sha1 checksum from.") List<Object> values) {
        return Utils.hexHash(DigestUtils.getSha1Digest(), values);
    }

    @UserFunction(value="apoc.util.sha256")
    @Description(value="Returns the SHA256 of the concatenation of all `STRING` values in the given `LIST<ANY>`.")
    public String sha256(@Name(value="values", description="The list of values to concatenate and generate a sha256 checksum from.") List<Object> values) {
        return Utils.hexHash(DigestUtils.getSha256Digest(), values);
    }

    @UserFunction(value="apoc.util.sha384")
    @Description(value="Returns the SHA384 of the concatenation of all `STRING` values in the given `LIST<ANY>`.")
    public String sha384(@Name(value="values", description="The list of values to concatenate and generate a sha384 checksum from.") List<Object> values) {
        return Utils.hexHash(DigestUtils.getSha384Digest(), values);
    }

    @UserFunction(value="apoc.util.sha512")
    @Description(value="Returns the SHA512 of the concatenation of all `STRING` values in the `LIST<ANY>`.")
    public String sha512(@Name(value="values", description="The list of values to concatenate and generate a sha512 checksum from.") List<Object> values) {
        return Utils.hexHash(DigestUtils.getSha512Digest(), values);
    }

    @UserFunction(value="apoc.util.md5")
    @Description(value="Returns the MD5 checksum of the concatenation of all `STRING` values in the given `LIST<ANY>`.\nMD5 is a weak hashing algorithm which is unsuitable for cryptographic use-cases.")
    public String md5(@Name(value="values", description="The list of values to concatenate and generate an md5 checksum from.") List<Object> values) {
        return Utils.hexHash(DigestUtils.getMd5Digest(), values);
    }

    @Procedure(value="apoc.util.sleep")
    @Description(value="Causes the currently running Cypher to sleep for the given duration of milliseconds (the transaction termination is honored).")
    public void sleep(@Name(value="duration", description="The milliseconds to sleep.") long duration) throws InterruptedException {
        long started = System.currentTimeMillis();
        while (System.currentTimeMillis() - started < duration) {
            try {
                Thread.sleep(5L);
                this.terminationGuard.check();
            }
            catch (TransactionTerminatedException e) {
                return;
            }
        }
    }

    @Procedure(value="apoc.util.validate")
    @Description(value="If the given predicate is true an exception is thrown.")
    public void validate(@Name(value="predicate", description="The predicate to check against.") boolean predicate, @Name(value="message", description="The error message to throw if the given predicate evaluates to true.") String message, @Name(value="params", description="The parameters for the given error message.") List<Object> params) {
        if (predicate) {
            if (params != null && !params.isEmpty()) {
                message = String.format(message, params.toArray(new Object[params.size()]));
            }
            throw new RuntimeException(message);
        }
    }

    @UserFunction(value="apoc.util.validatePredicate")
    @Description(value="If the given predicate is true an exception is thrown, otherwise it returns true (for use inside `WHERE` subclauses).")
    public boolean validatePredicate(@Name(value="predicate", description="The predicate to be evaluated.") Boolean predicate, @Name(value="message", description="The error message thrown if the predicate evaluates to `true`.") String message, @Name(value="params", description="Parameters to format the message with.") List<Object> params) {
        if (predicate != null && predicate.booleanValue()) {
            if (params != null && !params.isEmpty()) {
                message = String.format(message, params.toArray(new Object[params.size()]));
            }
            throw new RuntimeException(message);
        }
        return true;
    }

    @UserFunction(value="apoc.util.decompress")
    @Description(value="Unzips the given byte array.")
    public String decompress(@Name(value="data", description="The bytearray of data to decompress.") byte[] data, @Name(value="config", defaultValue="{}", description="{ compression = \"GZIP\" :: [\"GZIP\", \"BZIP2\", \"DEFLATE\", \"BLOCK_LZ4\", \"FRAMED_SNAPPY\", \"NONE\"], charset = \"UTF_8\" ::[\"UTF-8\", \"UTF-16\", \"UTF-16BE\", \"UTF-16LE\", \"UTF-32\", \"US-ASCII\", \"ISO-8859-1\"] }") Map<String, Object> config) throws Exception {
        CompressionConfig conf = new CompressionConfig(config, CompressionAlgo.GZIP.name());
        return CompressionAlgo.valueOf(conf.getCompressionAlgo()).decompress(data, conf.getCharset());
    }

    @UserFunction(value="apoc.util.compress")
    @Description(value="Zips the given `STRING`.")
    public byte[] compress(@Name(value="data", description="The string to be compressed.") String data, @Name(value="config", defaultValue="{}", description="{ compression = \"GZIP\" :: [\"GZIP\", \"BZIP2\", \"DEFLATE\", \"BLOCK_LZ4\", \"FRAMED_SNAPPY\", \"NONE\"], charset = \"UTF_8\" ::[\"UTF-8\", \"UTF-16\", \"UTF-16BE\", \"UTF-16LE\", \"UTF-32\", \"US-ASCII\", \"ISO-8859-1\"] }") Map<String, Object> config) throws Exception {
        CompressionConfig conf = new CompressionConfig(config, CompressionAlgo.GZIP.name());
        return CompressionAlgo.valueOf(conf.getCompressionAlgo()).compress(data, conf.getCharset());
    }

    private static String hexHash(MessageDigest digest, List<Object> values) {
        for (Object value : values) {
            digest.update(StringUtils.getBytesUtf8((String)Utils.toHashString(value)));
        }
        return Hex.encodeHexString((byte[])digest.digest());
    }

    private static String toHashString(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (value == null) {
            return "";
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().map(Utils::toHashString).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet().stream().map(e -> Map.entry(e.getKey().toString(), Utils.toHashString(e.getValue()))).sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ", "{", "}"));
        }
        if (value.getClass().isArray()) {
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                return Arrays.toString(objectArray);
            }
            if (value instanceof int[]) {
                int[] intArray = (int[])value;
                return Arrays.toString(intArray);
            }
            if (value instanceof long[]) {
                long[] longArray = (long[])value;
                return Arrays.toString(longArray);
            }
            if (value instanceof double[]) {
                double[] doubleArray = (double[])value;
                return Arrays.toString(doubleArray);
            }
            if (value instanceof short[]) {
                short[] shortArray = (short[])value;
                return Arrays.toString(shortArray);
            }
            if (value instanceof boolean[]) {
                boolean[] boolArray = (boolean[])value;
                return Arrays.toString(boolArray);
            }
            if (value instanceof byte[]) {
                byte[] byteArray = (byte[])value;
                return Arrays.toString(byteArray);
            }
            if (value instanceof float[]) {
                float[] floatArray = (float[])value;
                return Arrays.toString(floatArray);
            }
            if (value instanceof char[]) {
                char[] charArray = (char[])value;
                return Arrays.toString(charArray);
            }
            return value.toString();
        }
        return value.toString();
    }
}

