/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Arrays;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.DenseOrderedWriter;
import org.roaringbitmap.OrderedWriter;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class SparseOrderedWriter
implements OrderedWriter {
    private static final int ARRAY_MAX_SIZE = 4096;
    private final RoaringBitmap underlying;
    private short[] values;
    private int valuesCount;
    private short currentKey;

    public SparseOrderedWriter(RoaringBitmap underlying) {
        this(underlying, 4096);
    }

    SparseOrderedWriter(RoaringBitmap underlying, int size) {
        this.underlying = underlying;
        this.valuesCount = 0;
        this.values = new short[size];
    }

    public SparseOrderedWriter() {
        this(new RoaringBitmap());
    }

    public RoaringBitmap getUnderlying() {
        return this.underlying;
    }

    @Override
    public void add(int value) {
        int valueIndex;
        short key = Util.highbits(value);
        short low = Util.lowbits(value);
        if (key != this.currentKey) {
            if (Util.compareUnsigned(key, this.currentKey) < 0) {
                throw new IllegalStateException("Must write in ascending key order");
            }
            this.flush();
        }
        if ((valueIndex = this.valuesCount++) > 0 && Util.compareUnsigned(low, this.values[valueIndex - 1]) <= 0) {
            throw new IllegalStateException("Must write in ascending order.");
        }
        if (valueIndex >= this.values.length) {
            this.valuesCount = this.values.length;
            throw new IndexOutOfBoundsException(String.format("Exceeded limit of %d values per container.", this.values.length));
        }
        this.currentKey = key;
        this.values[valueIndex] = low;
    }

    @Override
    public void flush() {
        if (this.valuesCount > 0) {
            short key;
            RoaringArray highLowContainer = this.underlying.highLowContainer;
            if (highLowContainer.size > 0 && Util.compareUnsigned(this.currentKey, key = highLowContainer.getKeyAtIndex(highLowContainer.size - 1)) <= 0) {
                throw new IllegalStateException("Cannot write " + this.currentKey + " after " + key);
            }
            highLowContainer.append(this.currentKey, this.buildBestContainer());
        }
    }

    public void clear() {
        this.valuesCount = 0;
    }

    private Container buildBestContainer() {
        short[] values = Arrays.copyOf(this.values, this.valuesCount);
        Container container = new ArrayContainer(values).runOptimize();
        this.valuesCount = 0;
        return container;
    }

    public DenseOrderedWriter transfer() {
        DenseOrderedWriter denseWriter = new DenseOrderedWriter(this.underlying);
        denseWriter.dirty = this.valuesCount > 0;
        for (int k = 0; k < this.valuesCount; ++k) {
            short x = this.values[k];
            int n = Util.toIntUnsigned(x) / 64;
            denseWriter.bitmap[n] = denseWriter.bitmap[n] | 1L << x;
        }
        this.clear();
        return denseWriter;
    }
}

