/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.concurrent.atomic.AtomicLong;

public interface DatabaseStateMonitor {
    public long getHosted();

    public void increaseHosted();

    public void decreaseHosted();

    public long getFailed();

    public void increaseFailed();

    public void decreaseFailed();

    public long getDesiredStarted();

    public void setDesiredStarted(long var1);

    public static class Counter
    implements DatabaseStateMonitor {
        private final AtomicLong hosted = new AtomicLong(0L);
        private final AtomicLong failed = new AtomicLong(0L);
        private final AtomicLong desiredStarted = new AtomicLong(0L);

        @Override
        public long getHosted() {
            return this.hosted.get();
        }

        @Override
        public void increaseHosted() {
            this.hosted.incrementAndGet();
        }

        @Override
        public void decreaseHosted() {
            this.hosted.decrementAndGet();
        }

        @Override
        public long getFailed() {
            return this.failed.get();
        }

        @Override
        public void increaseFailed() {
            this.failed.incrementAndGet();
        }

        @Override
        public void decreaseFailed() {
            this.failed.decrementAndGet();
        }

        @Override
        public long getDesiredStarted() {
            return this.desiredStarted.get();
        }

        @Override
        public void setDesiredStarted(long newDesiredStarted) {
            this.desiredStarted.set(newDesiredStarted);
        }
    }
}

