/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.ArrayList;
import java.util.Comparator;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.graphdb.Transaction;

public class KnownSystemComponentVersions<T extends KnownSystemComponentVersion> {
    public final T noComponentVersion;
    private final ArrayList<T> knownComponentVersions = new ArrayList();

    public KnownSystemComponentVersions(T noComponentVersion) {
        this.noComponentVersion = noComponentVersion;
    }

    public void add(T version) {
        this.knownComponentVersions.add(version);
    }

    public T detectCurrentComponentVersion(Transaction tx) {
        ArrayList<T> sortedVersions = new ArrayList<T>(this.knownComponentVersions);
        sortedVersions.sort(Comparator.comparingInt(KnownSystemComponentVersion::binaryVersion).reversed());
        for (KnownSystemComponentVersion version : sortedVersions) {
            if (!version.detected(tx)) continue;
            return (T)version;
        }
        return this.noComponentVersion;
    }

    public T latestComponentVersion() {
        Object latest = this.noComponentVersion;
        for (KnownSystemComponentVersion knownComponentVersion : this.knownComponentVersions) {
            if (knownComponentVersion.version <= ((KnownSystemComponentVersion)latest).version) continue;
            latest = knownComponentVersion;
        }
        return latest;
    }

    public T findComponentVersion(ComponentVersion componentVersion) {
        for (KnownSystemComponentVersion knownComponentVersion : this.knownComponentVersions) {
            if (knownComponentVersion.version != componentVersion.getVersion()) continue;
            return (T)knownComponentVersion;
        }
        return this.noComponentVersion;
    }
}

