/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class NoSuchConstraintException
extends SchemaKernelException {
    private static final String MESSAGE = "No such constraint %s.";

    private NoSuchConstraintException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintNotFound, message);
    }

    public static NoSuchConstraintException noSuchConstraint(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N64).withParam(GqlParams.StringParam.constrDescrOrName, name).build();
        return new NoSuchConstraintException(gql, String.format(MESSAGE, name));
    }

    public static NoSuchConstraintException noSuchConstraint(SchemaDescriptorSupplier constraint, TokenNameLookup lookup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N64).withParam(GqlParams.StringParam.constrDescrOrName, constraint.userDescription(lookup)).build();
        return new NoSuchConstraintException(gql, String.format(MESSAGE, constraint.userDescription(lookup)));
    }
}

