/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;

class StateNodeRelationshipIds
implements RelationshipModifications.NodeRelationshipIds {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateNodeRelationshipIds.class);
    private final NodeStateImpl nodeState;
    private final boolean hasCreations;
    private final boolean hasDeletions;
    private final boolean hasUpdates;
    private final RelationshipModifications.IdDataDecorator relationshipVisit;

    static StateNodeRelationshipIds createStateNodeRelationshipIds(NodeStateImpl nodeState, RelationshipModifications.IdDataDecorator relationshipVisit, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new StateNodeRelationshipIds(nodeState, relationshipVisit);
    }

    private StateNodeRelationshipIds(NodeStateImpl nodeState, RelationshipModifications.IdDataDecorator relationshipVisit) {
        this.nodeState = nodeState;
        this.hasCreations = nodeState.hasAddedRelationships();
        this.hasDeletions = nodeState.hasRemovedRelationships();
        this.hasUpdates = nodeState.hasUpdatedRelationships();
        this.relationshipVisit = relationshipVisit;
    }

    public long nodeId() {
        return this.nodeState.getId();
    }

    public boolean hasCreations() {
        return this.hasCreations;
    }

    public boolean hasCreations(int type) {
        return this.hasCreations && this.nodeState.hasAddedRelationships(type);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    public boolean hasUpdates() {
        return this.hasUpdates;
    }

    public RelationshipModifications.RelationshipBatch creations() {
        return this.nodeState.additionsAsRelationshipBatch(this.relationshipVisit);
    }

    public RelationshipModifications.RelationshipBatch deletions() {
        return this.nodeState.removalsAsRelationshipBatch(RelationshipModifications.noAdditionalDataDecorator());
    }

    public void forEachCreationSplitInterruptible(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
        this.nodeState.visitAddedIdsSplit(visitor, this.relationshipVisit);
    }

    public void forEachDeletionSplitInterruptible(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
        this.nodeState.visitRemovedIdsSplit(visitor);
    }

    public void forEachUpdateSplitInterruptible(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
        this.nodeState.visitUpdatedIdsSplit(visitor, this.relationshipVisit);
    }
}

