/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.serial;

import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.transaction.serial.DatabaseSerialGuard;
import org.neo4j.kernel.impl.api.transaction.serial.SerialExecutionGuard;

public final class TransactionSerialExecutionGuard
implements SerialExecutionGuard {
    private final DatabaseSerialGuard databaseSerialGuard;
    private final KernelTransaction transaction;

    public TransactionSerialExecutionGuard(DatabaseSerialGuard databaseSerialGuard, KernelTransaction transaction) {
        this.databaseSerialGuard = databaseSerialGuard;
        this.transaction = transaction;
    }

    @Override
    public void check() {
        long serialExecution = this.databaseSerialGuard.serialExecution();
        if (0L == serialExecution) {
            return;
        }
        if (KernelTransaction.Type.SERIAL != this.transaction.transactionType() && this.transaction.getTransactionSequenceNumber() >= serialExecution) {
            throw TransientTransactionFailureException.internalError((String)"Transaction changes aborted due to serial transaction guard enforcement.", (String)("Serial transaction sequence number: " + serialExecution + " enforced termination of transaction with sequence number: " + this.transaction.getTransactionSequenceNumber()), (Status)Status.Transaction.TransactionValidationFailed);
        }
    }

    @Override
    public void release() {
        if (KernelTransaction.Type.SERIAL == this.transaction.transactionType()) {
            this.databaseSerialGuard.releaseSerialLock();
        }
    }
}

