/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.MultiPropertyConstraintDefinition;

abstract class NodeConstraintDefinition
extends MultiPropertyConstraintDefinition {
    protected final Label label;

    NodeConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, Label label, String[] propertyKeys) {
        super(actions, constraint, propertyKeys);
        this.label = Objects.requireNonNull(label);
    }

    NodeConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, IndexDefinition indexDefinition) {
        super(actions, constraint, indexDefinition);
        if (indexDefinition.isMultiTokenIndex()) {
            throw new IllegalArgumentException("Node constraints do not support multi-token definitions. That is, they cannot apply to more than one label, but an attempt was made to create a node constraint on the following labels: " + IndexDefinitionImpl.labelNameList(indexDefinition.getLabels(), "", "."));
        }
        this.label = (Label)Iterables.single((Iterable)indexDefinition.getLabels());
    }

    @Override
    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        return this.label;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeConstraintDefinition that = (NodeConstraintDefinition)o;
        return this.label.name().equals(that.label.name()) && Arrays.equals(this.propertyKeys, that.propertyKeys);
    }

    @Override
    public int hashCode() {
        return 31 * this.label.name().hashCode() + Arrays.hashCode(this.propertyKeys);
    }
}

