/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.util.Preconditions;

record BlockEntry<KEY, VALUE>(KEY key, VALUE value) {
    private static final int ENTRY_OVERHEAD = 4;

    @Override
    public String toString() {
        return String.format("[%s=%s]", this.key, this.value);
    }

    static <VALUE, KEY> int entrySize(Layout<KEY, VALUE> layout, KEY key, VALUE value) {
        int keySize = layout.keySize(key);
        int valueSize = layout.valueSize(value);
        return keySize + valueSize + 4;
    }

    static <VALUE, KEY> int keySize(Layout<KEY, VALUE> layout, KEY key) {
        int keySize = layout.keySize(key);
        return keySize + 4;
    }

    static <KEY, VALUE> BlockEntry<KEY, VALUE> read(PageCursor pageCursor, Layout<KEY, VALUE> layout) {
        Object key = layout.newKey();
        Object value = layout.newValue();
        BlockEntry.read(pageCursor, layout, key, value);
        return new BlockEntry<Object, Object>(key, value);
    }

    static <KEY, VALUE> void read(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key, VALUE value) {
        short keySize = pageCursor.getShort();
        short valueSize = pageCursor.getShort();
        layout.readKey(pageCursor, key, (int)keySize);
        layout.readValue(pageCursor, value, (int)valueSize);
    }

    static <KEY, VALUE> void read(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key) {
        short keySize = pageCursor.getShort();
        short valueSize = pageCursor.getShort();
        Preconditions.checkState((valueSize == 0 ? 1 : 0) != 0, (String)"Expected 0 value size");
        layout.readKey(pageCursor, key, (int)keySize);
    }

    static <KEY, VALUE> void write(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key, VALUE value) {
        int keySize = layout.keySize(key);
        int valueSize = layout.valueSize(value);
        Preconditions.checkState(((short)keySize == keySize ? 1 : 0) != 0, (String)"Key size overflow");
        Preconditions.checkState(((short)valueSize == valueSize ? 1 : 0) != 0, (String)"Value size overflow");
        pageCursor.putShort((short)keySize);
        pageCursor.putShort((short)valueSize);
        layout.writeKey(pageCursor, key);
        layout.writeValue(pageCursor, value);
    }

    static <KEY, VALUE> void write(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key) {
        int keySize = layout.keySize(key);
        Preconditions.checkState(((short)keySize == keySize ? 1 : 0) != 0, (String)"Key size overflow");
        pageCursor.putShort((short)keySize);
        pageCursor.putShort((short)0);
        layout.writeKey(pageCursor, key);
    }
}

