/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.PointKeyUtil;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GeometryType
extends Type {
    GeometryType(byte typeId) {
        super(ValueGroup.GEOMETRY, typeId, (Value)PointValue.MIN_VALUE, (Value)PointValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey<?> state) {
        int coordinatesSize = GeometryType.dimensions(state) * 8;
        return 3 + coordinatesSize;
    }

    static int dimensions(GenericKey<?> state) {
        return Math.toIntExact(state.long2);
    }

    @Override
    void copyValue(GenericKey<?> to, GenericKey<?> from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        int dimensions = GeometryType.dimensions(from);
        to.long0Array = GeometryType.ensureBigEnough(to.long0Array, dimensions);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, dimensions);
    }

    @Override
    Value asValue(GenericKey<?> state) {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)((int)state.long0), (int)((int)state.long1));
        return GeometryType.asValue(state, crs, 0);
    }

    static PointValue asValue(GenericKey<?> state, CoordinateReferenceSystem crs, int offset) {
        double[] coordinates = new double[GeometryType.dimensions(state)];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = Double.longBitsToDouble(state.long0Array[offset + i]);
        }
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
    }

    @Override
    int compareValue(GenericKey<?> left, GenericKey<?> right) {
        return GeometryType.compare(left.long0, left.long1, left.long2, left.long0Array, 0, right.long0, right.long1, right.long2, right.long0Array, 0);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey<?> state) {
        GeometryType.putCrs(cursor, state.long0, state.long1, state.long2);
        GeometryType.putPoint(cursor, state.long2, state.long0Array, 0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey<?> into) {
        return GeometryType.readCrs(cursor, into) && GeometryType.readPoint(cursor, into);
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey<?> state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
    }

    static int compare(long this_long0, long this_long1, long this_long2, long[] this_long0Array, int this_coordinates_offset, long that_long0, long that_long1, long that_long2, long[] that_long0Array, int that_coordinates_offset) {
        int tableIdComparison = Integer.compare((int)this_long0, (int)that_long0);
        if (tableIdComparison != 0) {
            return tableIdComparison;
        }
        int codeComparison = Integer.compare((int)this_long1, (int)that_long1);
        if (codeComparison != 0) {
            return codeComparison;
        }
        for (int i = 0; i < (int)this_long2; ++i) {
            double thatCoord;
            double thisCoord = Double.longBitsToDouble(this_long0Array[this_coordinates_offset + i]);
            int coordinateComparison = Double.compare(thisCoord, thatCoord = Double.longBitsToDouble(that_long0Array[that_coordinates_offset + i]));
            if (coordinateComparison == 0) continue;
            return coordinateComparison;
        }
        return 0;
    }

    static boolean readCrs(PageCursor cursor, GenericKey<?> into) {
        int header = PointKeyUtil.readHeader(cursor);
        into.long0 = PointKeyUtil.crsTableId(header);
        into.long1 = PointKeyUtil.crsCode(header);
        into.long2 = PointKeyUtil.dimensions(header);
        return true;
    }

    private static boolean readPoint(PageCursor cursor, GenericKey<?> into) {
        int dimensions = GeometryType.dimensions(into);
        into.long0Array = GeometryType.ensureBigEnough(into.long0Array, dimensions);
        for (int i = 0; i < dimensions; ++i) {
            into.long0Array[i] = cursor.getLong();
        }
        return true;
    }

    static void putCrs(PageCursor cursor, long tableId, long code, long dimensions) {
        PointKeyUtil.writeHeader(cursor, tableId, code, dimensions);
    }

    static void putPoint(PageCursor cursor, long dimensions, long[] coordinate, int long0ArrayOffset) {
        int i = 0;
        while ((long)i < dimensions) {
            cursor.putLong(coordinate[long0ArrayOffset + i]);
            ++i;
        }
    }

    static void write(RangeKey state, int tableId, int code, double[] coordinate) {
        state.long0 = tableId;
        state.long1 = code;
        state.long0Array = GeometryType.ensureBigEnough(state.long0Array, coordinate.length);
        for (int i = 0; i < coordinate.length; ++i) {
            state.long0Array[i] = Double.doubleToLongBits(coordinate[i]);
        }
        state.long2 = coordinate.length;
    }
}

