/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;

abstract class IndexLayout<KEY extends NativeIndexKey<KEY>>
extends Layout.Adapter<KEY, NullValue> {
    static final String INVALID_COMPARE_ID_IN_SEEK = "Used a key with `compareId=false` in a seek. That is not allowed. Instead, set the entity ID of the lower key to Long.MIN_VALUE and the entity ID of the upper key to Long.MA_VALUE";

    IndexLayout(boolean fixedSize, long identifier, int majorVersion, int minorVersion) {
        super(fixedSize, identifier, majorVersion, minorVersion);
    }

    public boolean fixedValueSize() {
        return true;
    }

    public NullValue newValue() {
        return NullValue.INSTANCE;
    }

    public int valueSize(NullValue nullValue) {
        return 0;
    }

    public void writeValue(PageCursor cursor, NullValue nullValue) {
    }

    public void readValue(PageCursor cursor, NullValue into, int valueSize) {
    }

    public void assertValidSeekKeys(KEY from, KEY to) {
        assert (((NativeIndexKey)((Object)from)).getCompareId()) : "Used a key with `compareId=false` in a seek. That is not allowed. Instead, set the entity ID of the lower key to Long.MIN_VALUE and the entity ID of the upper key to Long.MA_VALUE";
        assert (((NativeIndexKey)((Object)to)).getCompareId()) : "Used a key with `compareId=false` in a seek. That is not allowed. Instead, set the entity ID of the lower key to Long.MIN_VALUE and the entity ID of the upper key to Long.MA_VALUE";
    }

    public final int compare(KEY o1, KEY o2) {
        int valueComparison = this.compareValue(o1, o2);
        if (valueComparison == 0 && ((NativeIndexKey)((Object)o1)).getCompareId() && ((NativeIndexKey)((Object)o2)).getCompareId()) {
            return Long.compare(((NativeIndexKey)((Object)o1)).getEntityId(), ((NativeIndexKey)((Object)o2)).getEntityId());
        }
        return valueComparison;
    }

    int compareValue(KEY o1, KEY o2) {
        return ((NativeIndexKey)((Object)o1)).compareValueTo(o2);
    }
}

