/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.values.storable.Value;

class AccessControlDataProvider
implements SelectedPropertiesProvider,
AutoCloseable {
    private final Supplier<BiConsumer<StoragePropertyCursor, PropertySelection>> propertyInitializer;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private final Supplier<Iterable<StorageProperty>> txStateProperties;
    private final Supplier<Read> readSupplier;
    private StoragePropertyCursor propertyCursor;
    private DefaultNodeCursor nodeCursor;
    private DefaultRelationshipScanCursor relationshipCursor;

    public AccessControlDataProvider(Supplier<BiConsumer<StoragePropertyCursor, PropertySelection>> propertyInitializer, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState, Supplier<Iterable<StorageProperty>> txStateProperties, Supplier<Read> readSupplier) {
        this.propertyInitializer = propertyInitializer;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
        this.txStateProperties = txStateProperties;
        this.readSupplier = readSupplier;
    }

    public IntObjectMap<Value> get(PropertySelection properties) {
        MutableIntObjectMap result = IntObjectMaps.mutable.empty();
        this.fillFromStorage(this.propertyInitializer.get(), properties, (MutableIntObjectMap<Value>)result);
        this.fillFromTxState(properties, (MutableIntObjectMap<Value>)result);
        return result;
    }

    private void fillFromTxState(PropertySelection propertySelection, MutableIntObjectMap<Value> result) {
        if (this.applyAccessModeToTxState) {
            Iterable<StorageProperty> txStateChangedProperties = this.txStateProperties.get();
            for (StorageProperty changedProperty : txStateChangedProperties) {
                if (!propertySelection.test(changedProperty.propertyKeyId())) continue;
                result.put(changedProperty.propertyKeyId(), (Object)changedProperty.value());
            }
        }
    }

    private void fillFromStorage(BiConsumer<StoragePropertyCursor, PropertySelection> propertyInitializer, PropertySelection propertySelection, MutableIntObjectMap<Value> result) {
        StoragePropertyCursor propertyCursor = this.getPropertyCursor();
        propertyInitializer.accept(propertyCursor, propertySelection);
        while (propertyCursor.next()) {
            result.put(propertyCursor.propertyKey(), (Object)propertyCursor.propertyValue());
        }
    }

    private StoragePropertyCursor getPropertyCursor() {
        if (this.propertyCursor == null) {
            this.propertyCursor = this.internalCursors.allocateStoragePropertyCursor();
        }
        return this.propertyCursor;
    }

    public TokenSet getLabels(long reference) {
        if (this.nodeCursor == null) {
            this.nodeCursor = this.internalCursors.allocateFullAccessNodeCursor();
        }
        this.readSupplier.get().singleNode(reference, (NodeCursor)this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new IllegalStateException("Node " + reference + " not found for security check");
        }
        return AccessControlDataProvider.nodeLabels(this.nodeCursor, this.applyAccessModeToTxState);
    }

    public static TokenSet nodeLabels(DefaultNodeCursor cursor, boolean applyAccessModeToTxState) {
        if (applyAccessModeToTxState) {
            return cursor.labels();
        }
        return cursor.labelsIgnoringTxStateSetRemove();
    }

    public int getRelType(long reference) {
        if (this.relationshipCursor == null) {
            this.relationshipCursor = this.internalCursors.allocateFullAccessRelationshipScanCursor();
        }
        this.readSupplier.get().singleRelationship(reference, (RelationshipScanCursor)this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new IllegalStateException("Relationship " + reference + " not found for security check");
        }
        return this.relationshipCursor.type();
    }

    @Override
    public void close() {
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
    }

    public void release() {
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor.release();
            this.nodeCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor.release();
            this.relationshipCursor = null;
        }
    }
}

