/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;

public abstract class ReaderLogVersionBridge
implements LogVersionBridge {
    public static LogVersionBridge forFile(LogFile logFile) {
        return (channel, raw) -> ReaderLogVersionBridge.swap(channel, version -> logFile.openForVersion(version, raw));
    }

    public static LogVersionBridge forFile(CheckpointFile logFile) {
        return (channel, raw) -> ReaderLogVersionBridge.swap(channel, logFile::openForVersion);
    }

    private static LogVersionedStoreChannel swap(LogVersionedStoreChannel prevChannel, ChannelProvider nextChannelProvider) throws IOException {
        LogVersionedStoreChannel nextChannel;
        try {
            nextChannel = nextChannelProvider.get(prevChannel.getLogVersion() + 1L);
        }
        catch (NoSuchFileException | IncompleteLogHeaderException e) {
            return prevChannel;
        }
        prevChannel.close();
        return nextChannel;
    }

    @FunctionalInterface
    private static interface ChannelProvider {
        public LogVersionedStoreChannel get(long var1) throws IOException;
    }
}

