/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.checkpoint.PeriodicThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.time.SystemNanoClock;

public interface CheckPointThreshold {
    public static final long DEFAULT_CHECKING_FREQUENCY_MILLIS = TimeUnit.SECONDS.toMillis(10L);

    public void initialize(long var1, LogPosition var3);

    public boolean isCheckPointingNeeded(long var1, LogPosition var3, Consumer<String> var4);

    public void checkPointHappened(long var1, LogPosition var3);

    public long checkFrequencyMillis();

    public static CheckPointThreshold createThreshold(Config config, SystemNanoClock clock, LogPruning logPruning, InternalLogProvider logProvider) {
        CheckPointThresholdPolicy policy;
        String policyName = ((GraphDatabaseSettings.CheckpointPolicy)config.get(GraphDatabaseSettings.check_point_policy)).name().toLowerCase(Locale.ROOT);
        try {
            policy = CheckPointThresholdPolicy.loadPolicy(policyName);
        }
        catch (NoSuchElementException e) {
            logProvider.getLog(CheckPointThreshold.class).warn("Could not load check point policy '" + GraphDatabaseSettings.check_point_policy.name() + "=" + policyName + "'. Using default policy instead.", (Throwable)e);
            policy = new PeriodicThresholdPolicy();
        }
        return policy.createThreshold(config, clock, logPruning, logProvider);
    }

    public static CheckPointThreshold or(final CheckPointThreshold ... thresholds) {
        return new CheckPointThreshold(){

            @Override
            public void initialize(long appendIndex, LogPosition logPosition) {
                for (CheckPointThreshold threshold : thresholds) {
                    threshold.initialize(appendIndex, logPosition);
                }
            }

            @Override
            public boolean isCheckPointingNeeded(long lastAppendIndex, LogPosition logPosition, Consumer<String> consumer) {
                for (CheckPointThreshold threshold : thresholds) {
                    if (!threshold.isCheckPointingNeeded(lastAppendIndex, logPosition, consumer)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void checkPointHappened(long appendIndex, LogPosition logPosition) {
                for (CheckPointThreshold threshold : thresholds) {
                    threshold.checkPointHappened(appendIndex, logPosition);
                }
            }

            @Override
            public long checkFrequencyMillis() {
                return Stream.of(thresholds).mapToLong(CheckPointThreshold::checkFrequencyMillis).min().orElse(DEFAULT_CHECKING_FREQUENCY_MILLIS);
            }
        };
    }
}

