/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.internal.helpers.collection.LfuCache;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.util.VisibleForTesting;

public class TransactionLogFileInformation
implements LogFileInformation {
    private final LogFiles logFiles;
    private final LogHeaderCache logHeaderCache;
    private final TransactionLogFilesContext logFileContext;
    private final TransactionLogFileTimestampMapper logFileTimestampMapper;

    TransactionLogFileInformation(LogFiles logFiles, LogHeaderCache logHeaderCache, TransactionLogFilesContext context) {
        this(logFiles, logHeaderCache, context, () -> new VersionAwareLogEntryReader(context.getCommandReaderFactory(), context.getBinarySupportedKernelVersions(), context.getMemoryTracker()));
    }

    @VisibleForTesting
    TransactionLogFileInformation(LogFiles logFiles, LogHeaderCache logHeaderCache, TransactionLogFilesContext context, Supplier<LogEntryReader> logEntryReaderFactory) {
        this.logFiles = logFiles;
        this.logHeaderCache = logHeaderCache;
        this.logFileContext = context;
        this.logFileTimestampMapper = new TransactionLogFileTimestampMapper(logFiles, logEntryReaderFactory);
    }

    @Override
    public long getPreviousAppendIndexFromHeader(long version) throws IOException {
        LogHeader logHeader = this.logHeaderCache.getLogHeader(version);
        if (logHeader != null) {
            return logHeader.getLastAppendIndex();
        }
        LogFile logFile = this.logFiles.getLogFile();
        if (logFile.versionExists(version) && (logHeader = logFile.extractHeader(version)) != null) {
            this.logHeaderCache.putHeader(version, logHeader);
            return logHeader.getLastAppendIndex();
        }
        return -1L;
    }

    @Override
    public long getLastEntryAppendIndex() {
        return this.logFileContext.getLastAppendIndexLogFilesProvider().getLastAppendIndex(this.logFiles);
    }

    @Override
    public long getFirstStartRecordTimestamp(long version) throws IOException {
        return this.logFileTimestampMapper.getTimestampForVersion(version);
    }

    private static class TransactionLogFileTimestampMapper {
        private static final String FIRST_TRANSACTION_TIME = "First Transaction Time";
        private final LogFiles logFiles;
        private final Supplier<LogEntryReader> logEntryReaderFactory;
        private final LfuCache<Long, Long> logFileTimeStamp = new LfuCache("First Transaction Time", 10000);

        TransactionLogFileTimestampMapper(LogFiles logFiles, Supplier<LogEntryReader> logEntryReaderFactory) {
            this.logFiles = logFiles;
            this.logEntryReaderFactory = logEntryReaderFactory;
        }

        long getTimestampForVersion(long version) throws IOException {
            LogHeader logHeader;
            Long cachedTimeStamp = (Long)this.logFileTimeStamp.get((Object)version);
            if (cachedTimeStamp != null) {
                return cachedTimeStamp;
            }
            LogFile logFile = this.logFiles.getLogFile();
            if (logFile.versionExists(version) && (logHeader = logFile.extractHeader(version)) != null) {
                LogPosition position = logHeader.getStartPosition();
                ReadableLogChannel channel = logFile.getRawReader(position);
                try {
                    LogEntry entry;
                    if (channel instanceof EnvelopeReadChannel) {
                        EnvelopeReadChannel envelopeReadChannel = (EnvelopeReadChannel)channel;
                        try {
                            envelopeReadChannel.alignWithStartEntry();
                        }
                        catch (ReadPastEndException e) {
                            long l = -1L;
                            if (channel != null) {
                                channel.close();
                            }
                            return l;
                        }
                    }
                    LogEntryReader logEntryReader = this.logEntryReaderFactory.get();
                    while ((entry = logEntryReader.readLogEntry((ReadableLogPositionAwareChannel)channel)) != null) {
                        if (entry instanceof LogEntryStart) {
                            LogEntryStart logEntryStart = (LogEntryStart)entry;
                            long l = this.cacheTimeWritten(version, logEntryStart.getTimeWritten());
                            return l;
                        }
                        if (!(entry instanceof LogEntryChunkStart)) continue;
                        LogEntryChunkStart chunkStart = (LogEntryChunkStart)entry;
                        long l = this.cacheTimeWritten(version, chunkStart.getTimeWritten());
                        return l;
                    }
                }
                finally {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            return -1L;
        }

        private long cacheTimeWritten(long version, long timeWritten) {
            this.logFileTimeStamp.put((Object)version, (Object)timeWritten);
            return timeWritten;
        }
    }
}

