/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LastAppendBatchInfoProvider;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class DetachedLogTailAppendIndexProvider
implements LastAppendBatchInfoProvider {
    private final LogFile logFile;
    private final KernelVersion kernelVersion;
    private final long startingAppendIndex;
    private final LogPosition logPosition;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final CommandReaderFactory commandReaderFactory;
    private final MemoryTracker memoryTracker;

    public DetachedLogTailAppendIndexProvider(CommandReaderFactory commandReaderFactory, BinarySupportedKernelVersions binarySupportedKernelVersions, LogFile logFile, KernelVersion kernelVersion, long startingAppendIndex, LogPosition logPosition, MemoryTracker memoryTracker) {
        this.logFile = logFile;
        this.kernelVersion = kernelVersion;
        this.startingAppendIndex = startingAppendIndex;
        this.logPosition = logPosition;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.commandReaderFactory = commandReaderFactory;
        this.memoryTracker = memoryTracker;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppendBatchInfo get() {
        if (this.logPosition == null) return new AppendBatchInfo(this.startingAppendIndex, LogPosition.UNSPECIFIED);
        if (this.logPosition == LogPosition.UNSPECIFIED) {
            return new AppendBatchInfo(this.startingAppendIndex, LogPosition.UNSPECIFIED);
        }
        long logVersion = this.logPosition.getLogVersion();
        boolean checkCommitEntries = this.kernelVersion.isLessThan(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED);
        long appendIndex = this.startingAppendIndex;
        LogPosition postLogPosition = this.logPosition;
        try {
            if (!this.logFile.versionExists(logVersion)) {
                return new AppendBatchInfo(appendIndex, postLogPosition);
            }
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions, this.memoryTracker);
            long currentFileVersion = this.logFile.getLogRangeInfo().highestVersion();
            while (currentFileVersion >= logVersion) {
                long currentAppendIndex = 0L;
                boolean infoFound = false;
                LogPosition logFileStartPosition = this.getLogFileStartPosition(currentFileVersion, logVersion);
                if (logFileStartPosition != null) {
                    if (appendIndex == 0L) {
                        appendIndex = this.logFile.extractHeader(currentFileVersion).getLastAppendIndex();
                    }
                    try (ReadableLogChannel reader = this.logFile.getReader(logFileStartPosition, ReaderLogVersionBridge.forFile(this.logFile));){
                        if (reader instanceof EnvelopeReadChannel) {
                            EnvelopeReadChannel envelopeReadChannel = (EnvelopeReadChannel)reader;
                            envelopeReadChannel.alignWithStartEntry();
                        }
                        try (LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                            while (cursor.next()) {
                                LogEntry entry = cursor.get();
                                if (entry instanceof LogEntryStart) {
                                    LogEntryStart startEntry = (LogEntryStart)entry;
                                    currentAppendIndex = startEntry.getAppendIndex();
                                    continue;
                                }
                                if (entry instanceof LogEntryChunkStart) {
                                    LogEntryChunkStart chunkStart = (LogEntryChunkStart)entry;
                                    currentAppendIndex = chunkStart.getAppendIndex();
                                    continue;
                                }
                                if (entry instanceof LogEntryRollback) {
                                    LogEntryRollback rollback = (LogEntryRollback)entry;
                                    appendIndex = rollback.getAppendIndex();
                                    postLogPosition = reader.getCurrentLogPosition();
                                    infoFound = true;
                                    continue;
                                }
                                if (!(entry instanceof LogEntryChunkEnd) && !(entry instanceof LogEntryCommit)) continue;
                                if (checkCommitEntries && entry instanceof LogEntryCommit) {
                                    LogEntryCommit commit = (LogEntryCommit)entry;
                                    currentAppendIndex = commit.getTxId();
                                }
                                appendIndex = currentAppendIndex;
                                postLogPosition = reader.getCurrentLogPosition();
                                currentAppendIndex = 0L;
                                infoFound = true;
                            }
                            if (infoFound) {
                                AppendBatchInfo appendBatchInfo = new AppendBatchInfo(appendIndex, postLogPosition);
                                return appendBatchInfo;
                            }
                        }
                    }
                    catch (IOException | IllegalStateException | UnsupportedLogVersionException e) {
                        return new AppendBatchInfo(appendIndex, postLogPosition);
                    }
                }
                --currentFileVersion;
            }
            return new AppendBatchInfo(appendIndex, postLogPosition);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to retrieve last append index", t);
        }
    }

    private LogPosition getLogFileStartPosition(long currentFileVersion, long logVersion) throws IOException {
        if (currentFileVersion == logVersion) {
            return this.logPosition;
        }
        LogHeader logHeader = this.logFile.extractHeader(currentFileVersion);
        if (logHeader == null) {
            return null;
        }
        return logHeader.getStartPosition();
    }
}

