/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.storageengine.api.ReadableStorageEngine;

public class IndexStoreViewFactory {
    private final FullScanStoreView fullScanStoreView;
    private final ReadableStorageEngine storageEngine;
    private final LockManager lockManager;
    private final LockService lockService;
    private final Config config;
    private final InternalLogProvider logProvider;

    public IndexStoreViewFactory(Config config, ReadableStorageEngine storageEngine, LockManager lockManager, FullScanStoreView fullScanStoreView, LockService lockService, InternalLogProvider logProvider) {
        this.storageEngine = storageEngine;
        this.lockManager = lockManager;
        this.lockService = lockService;
        this.config = config;
        this.logProvider = logProvider;
        this.fullScanStoreView = fullScanStoreView;
    }

    public IndexStoreView createTokenIndexStoreView(IndexingService.IndexProxyProvider indexProxies) {
        return new DynamicIndexStoreView(this.fullScanStoreView, this.lockManager, this.lockService, this.config, indexProxies, this.storageEngine, this.logProvider);
    }
}

