/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.BaseCoreAPIPath;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class DefaultValueMapper
extends ValueMapper.JavaMapper {
    private final InternalTransaction transaction;

    public DefaultValueMapper(InternalTransaction transaction) {
        this.transaction = transaction;
    }

    public Node mapNode(VirtualNodeValue value) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            return ((NodeEntityWrappingNodeValue)value).getEntity();
        }
        return this.mapNode(value.id());
    }

    public Relationship mapRelationship(VirtualRelationshipValue value) {
        if (value instanceof RelationshipEntityWrappingValue) {
            return ((RelationshipEntityWrappingValue)value).getEntity();
        }
        return this.mapRelationship(value.id());
    }

    public Path mapPath(VirtualPathValue value) {
        if (value instanceof PathWrappingPathValue) {
            return ((PathWrappingPathValue)value).path();
        }
        return new CoreAPIPath(value);
    }

    private Node mapNode(long value) {
        return new NodeEntity(this.transaction, value);
    }

    private Relationship mapRelationship(long value) {
        return new RelationshipEntity(this.transaction, value);
    }

    private class CoreAPIPath
    extends BaseCoreAPIPath {
        CoreAPIPath(VirtualPathValue value) {
            super(value);
        }

        @Override
        protected Node mapNode(long value) {
            return DefaultValueMapper.this.mapNode(value);
        }

        @Override
        protected Relationship mapRelationship(long value) {
            return DefaultValueMapper.this.mapRelationship(value);
        }
    }
}

