/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerInternal;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.monitoring.DefaultDatabaseEvent;
import org.neo4j.kernel.monitoring.ExceptionalDatabaseEvent;
import org.neo4j.logging.InternalLog;

public class DatabaseEventListeners {
    private final List<DatabaseEventListener> databaseEventListeners = new CopyOnWriteArrayList<DatabaseEventListener>();
    private final InternalLog log;

    public DatabaseEventListeners(InternalLog log) {
        this.log = log;
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        DatabaseEventListeners.addListener(listener, this.databaseEventListeners);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        DatabaseEventListeners.removeListener(listener, this.databaseEventListeners);
    }

    private static <T> void addListener(T listener, List<T> listeners) {
        if (listeners.contains(listener)) {
            return;
        }
        listeners.add(listener);
    }

    private static <T> void removeListener(T listener, List<T> listeners) {
        if (!listeners.remove(listener)) {
            throw new IllegalStateException("Database listener `" + String.valueOf(listener) + "` is not registered.");
        }
    }

    public void databaseStart(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseStart((DatabaseEventContext)event), this.databaseEventListeners);
    }

    public void databaseShutdown(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseShutdown((DatabaseEventContext)event), this.databaseEventListeners);
    }

    public void databaseCreate(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseCreate((DatabaseEventContext)event), this.databaseEventListeners);
    }

    public void databaseDrop(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseDrop((DatabaseEventContext)event), this.databaseEventListeners);
    }

    void databasePanic(NamedDatabaseId databaseId, Throwable causeOfPanic) {
        ExceptionalDatabaseEvent event = new ExceptionalDatabaseEvent(databaseId, causeOfPanic);
        this.notifyEventListeners(handler -> handler.databasePanic((DatabaseEventContext)event), this.databaseEventListeners);
    }

    void databaseOutOfDiskSpace(NamedDatabaseId databaseId, Throwable cause) {
        ExceptionalDatabaseEvent event = new ExceptionalDatabaseEvent(databaseId, cause);
        this.notifyEventListeners(handler -> {
            if (handler instanceof DatabaseEventListenerInternal) {
                DatabaseEventListenerInternal internal = (DatabaseEventListenerInternal)handler;
                internal.databaseOutOfDiskSpace((DatabaseEventContext)event);
            }
        }, this.databaseEventListeners);
    }

    private <T> void notifyEventListeners(Consumer<T> consumer, List<T> listeners) {
        for (T listener : listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable e) {
                this.log.error("Error while handling database event by listener: " + String.valueOf(listener), e);
            }
        }
    }
}

