/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.recovery.RollbackTransactionInfo;
import org.neo4j.storageengine.api.TransactionId;

class RecoveryContextTracker {
    private CommittedCommandBatchRepresentation.BatchInformation lastHighestTransactionBatchInfo = null;
    private CommittedCommandBatchRepresentation.BatchInformation lastBatchInfo = null;
    private LogPosition recoveryToPosition;
    private LogPosition lastTransactionPosition;
    private long recoveredBatches;

    RecoveryContextTracker(LogPosition recoveryStartPosition, CheckpointInfo checkpointInfo) {
        this.updatePositions(recoveryStartPosition);
        this.initInitialInfo(checkpointInfo);
    }

    private void initInitialInfo(CheckpointInfo checkpointInfo) {
        if (checkpointInfo == null) {
            return;
        }
        TransactionId checkpointTransactionId = checkpointInfo.transactionId();
        CommittedCommandBatchRepresentation.BatchInformation checkpointBatchInfo = new CommittedCommandBatchRepresentation.BatchInformation(checkpointTransactionId, checkpointTransactionId.appendIndex());
        TransactionId transactionId = checkpointInfo.transactionId();
        this.lastBatchInfo = new CommittedCommandBatchRepresentation.BatchInformation(transactionId, checkpointInfo.appendIndex());
        this.lastHighestTransactionBatchInfo = checkpointBatchInfo;
    }

    void commitedBatch(CommittedCommandBatchRepresentation nextCommandBatch, LogPosition position) {
        CommittedCommandBatchRepresentation.BatchInformation batchInfo = nextCommandBatch.batchInformation();
        if (this.updateHighestBatchInfo(nextCommandBatch.txId())) {
            this.lastHighestTransactionBatchInfo = batchInfo;
        }
        this.lastBatchInfo = batchInfo;
        this.updatePositions(position);
        ++this.recoveredBatches;
    }

    void rollbackBatch(RollbackTransactionInfo rollbackTransactionInfo, LogPosition position) {
        if (this.updateHighestBatchInfo(rollbackTransactionInfo.batchInfo().txId())) {
            this.lastHighestTransactionBatchInfo = rollbackTransactionInfo.batchInfo();
        }
        this.updatePositions(position);
    }

    private boolean updateHighestBatchInfo(long id) {
        return this.lastHighestTransactionBatchInfo == null || this.lastHighestTransactionBatchInfo.txId() < id;
    }

    void completeRecovery(LogPosition logPosition) {
        this.recoveryToPosition = logPosition;
    }

    private void updatePositions(LogPosition position) {
        this.recoveryToPosition = position;
        this.lastTransactionPosition = position;
    }

    CommittedCommandBatchRepresentation.BatchInformation getLastHighestTransactionBatchInfo() {
        return this.lastHighestTransactionBatchInfo;
    }

    CommittedCommandBatchRepresentation.BatchInformation getLastBatchInfo() {
        return this.lastBatchInfo;
    }

    LogPosition getRecoveryToPosition() {
        return this.recoveryToPosition;
    }

    LogPosition getLastTransactionPosition() {
        return this.lastTransactionPosition;
    }

    boolean hasRecoveredBatches() {
        return this.recoveredBatches > 0L;
    }
}

