/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformation;

public class RecoveryStartInformationProvider
implements ThrowingSupplier<RecoveryStartInformation, IOException> {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private final LogFiles logFiles;
    private final Monitor monitor;

    RecoveryStartInformationProvider(LogFiles logFiles, Monitor monitor) {
        this.logFiles = logFiles;
        this.monitor = monitor;
    }

    public RecoveryStartInformation get() {
        LogTailInformation logTailInformation = (LogTailInformation)this.logFiles.getTailMetadata();
        CheckpointInfo lastCheckPoint = logTailInformation.lastCheckPoint;
        long appendIndexAfterLastCheckPoint = logTailInformation.firstAppendIndexAfterLastCheckPoint;
        if (!logTailInformation.isRecoveryRequired()) {
            LogPosition logPosition = lastCheckPoint != null ? lastCheckPoint.transactionLogPosition() : null;
            this.monitor.recoveryNotRequired(logPosition);
            return RecoveryStartInformation.NO_RECOVERY_REQUIRED;
        }
        if (logTailInformation.logsMissing()) {
            return RecoveryStartInformation.MISSING_LOGS;
        }
        if (logTailInformation.hasRecordsToRecover()) {
            if (lastCheckPoint == null) {
                return this.noCheckpointRecordRecoveryInfo(appendIndexAfterLastCheckPoint);
            }
            return this.checkpointBasedRecoveryInfo(lastCheckPoint, appendIndexAfterLastCheckPoint);
        }
        if (logTailInformation.hasUnreadableBytesInCheckpointLogs()) {
            return new RecoveryStartInformation(lastCheckPoint.transactionLogPosition(), lastCheckPoint.oldestNotVisibleTransactionLogPosition(), lastCheckPoint, lastCheckPoint.appendIndex());
        }
        throw new UnderlyingStorageException("Fail to determine recovery information Log tail info: " + String.valueOf(logTailInformation));
    }

    private RecoveryStartInformation checkpointBasedRecoveryInfo(CheckpointInfo lastCheckPoint, long appendIndexAfterLastCheckPoint) {
        LogPosition transactionLogPosition = lastCheckPoint.transactionLogPosition();
        LogPosition oldestNotVisibleTransactionLogPosition = lastCheckPoint.oldestNotVisibleTransactionLogPosition();
        this.monitor.recoveryRequiredAfterLastCheckPoint(transactionLogPosition, oldestNotVisibleTransactionLogPosition, appendIndexAfterLastCheckPoint);
        return new RecoveryStartInformation(transactionLogPosition, oldestNotVisibleTransactionLogPosition, lastCheckPoint, appendIndexAfterLastCheckPoint);
    }

    private RecoveryStartInformation noCheckpointRecordRecoveryInfo(long appendIndexAfterLastCheckPoint) {
        long lowestLogVersion = this.logFiles.getLogFile().getLogRangeInfo().lowestVersion();
        if (lowestLogVersion != 0L) {
            throw new UnderlyingStorageException("No check point found in any log file and transaction log files do not exist from expected version 0. Lowest found log file is " + lowestLogVersion + ".");
        }
        this.monitor.noCheckPointFound();
        LogPosition position = this.tryExtractHeaderAndGetStartPosition();
        return new RecoveryStartInformation(position, position, null, appendIndexAfterLastCheckPoint);
    }

    private LogPosition tryExtractHeaderAndGetStartPosition() {
        try {
            return this.logFiles.getLogFile().extractHeader(0L).getStartPosition();
        }
        catch (IOException e) {
            this.monitor.failToExtractInitialFileHeader(e);
            throw new UnderlyingStorageException("Unable to read header from log file with version 0", (Throwable)e);
        }
    }

    public static interface Monitor {
        default public void recoveryNotRequired(LogPosition logPosition) {
        }

        default public void recoveryRequiredAfterLastCheckPoint(LogPosition logPosition, LogPosition oldestNotVisibleTransactionLogPosition, long appendIndexAfterLastCheckPoint) {
        }

        default public void noCheckPointFound() {
        }

        default public void failToExtractInitialFileHeader(Exception e) {
        }
    }
}

