/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.internal.AbstractLogService;
import org.neo4j.logging.internal.DatabaseLogIdentifier;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.logging.internal.LogService;

public class DatabaseLogService
extends AbstractLogService {
    private final DatabaseLogProvider userLogProvider;
    private final DatabaseLogProvider internalLogProvider;

    public DatabaseLogService(NamedDatabaseId databaseId, LogService delegate) {
        this(DatabaseLogIdentifier.create(databaseId), delegate);
    }

    public DatabaseLogService(DatabaseLogIdentifier databaseLogIdentifier, LogService delegate) {
        this.userLogProvider = new DatabaseLogProvider(databaseLogIdentifier, delegate.getUserLogProvider());
        this.internalLogProvider = new DatabaseLogProvider(databaseLogIdentifier, delegate.getInternalLogProvider());
    }

    public DatabaseLogProvider getUserLogProvider() {
        return this.userLogProvider;
    }

    public DatabaseLogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }
}

