/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.ResourcePool;
import org.neo4j.cypher.internal.runtime.SingleThreadedResourcePool$;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.lang.AutoCloseablePlus;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\f\u0019\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\b\u0003\u0004D\u0001\u0001\u0006Ka\f\u0005\u0007\t\u0002\u0001\u000b\u0015B#\t\r9\u0003\u0001\u0015)\u0003P\u0011\u0019\u0011\u0006\u0001)Q\u0005'\")a\u000b\u0001C\u0001/\")Q\f\u0001C\u0001=\")\u0001\r\u0001C\u0001C\")a\u000e\u0001C\u0005_\")\u0001\u000f\u0001C\u0001c\")A\u0010\u0001C\u0001_\")Q\u0010\u0001C!}\")q\u0010\u0001C\u0005_\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\rqaBA\u00061!\u0005\u0011Q\u0002\u0004\u0007/aA\t!a\u0004\t\ru\u001aB\u0011AA\t\u0011%\t\u0019b\u0005b\u0001\n\u0013\t)\u0002C\u0004\u0002\u0018M\u0001\u000b\u0011B(\u00035MKgn\u001a7f)\"\u0014X-\u00193fIJ+7o\\;sG\u0016\u0004vn\u001c7\u000b\u0005eQ\u0012a\u0002:v]RLW.\u001a\u0006\u00037q\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003;y\taaY=qQ\u0016\u0014(BA\u0010!\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0013aA8sO\u000e\u00011c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0017\u000e\u0003aI!!\f\r\u0003\u0019I+7o\\;sG\u0016\u0004vn\u001c7\u0002\u0011\r\f\u0007/Y2jif\u0004\"!\n\u0019\n\u0005E2#aA%oi\u00069Qn\u001c8ji>\u0014\bCA\u00165\u0013\t)\u0004DA\bSKN|WO]2f\u001b>t\u0017\u000e^8s\u00035iW-\\8ssR\u0013\u0018mY6feB\u0011\u0001hO\u0007\u0002s)\u0011!HH\u0001\u0007[\u0016lwN]=\n\u0005qJ$!D'f[>\u0014\u0018\u0010\u0016:bG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0005\u007f\u0001\u000b%\t\u0005\u0002,\u0001!)a\u0006\u0002a\u0001_!)!\u0007\u0002a\u0001g!)a\u0007\u0002a\u0001o\u0005A\u0001.[4i\u001b\u0006\u00148.\u0001\u0006dY>\u001cX-\u00192mKN\u00042!\n$I\u0013\t9eEA\u0003BeJ\f\u0017\u0010\u0005\u0002J\u00196\t!J\u0003\u0002L=\u0005!A.\u00198h\u0013\ti%JA\tBkR|7\t\\8tK\u0006\u0014G.\u001a)mkN\f1\u0002\u001e:bG.,GmU5{KB\u0011Q\u0005U\u0005\u0003#\u001a\u0012A\u0001T8oO\u0006Iq,[:DY>\u001cX\r\u001a\t\u0003KQK!!\u0016\u0014\u0003\u000f\t{w\u000e\\3b]\u0006\u0019\u0011\r\u001a3\u0015\u0005a[\u0006CA\u0013Z\u0013\tQfE\u0001\u0003V]&$\b\"\u0002/\n\u0001\u0004A\u0015\u0001\u0003:fg>,(oY3\u0002\rI,Wn\u001c<f)\t\u0019v\fC\u0003]\u0015\u0001\u0007\u0001*A\u0002bY2$\u0012A\u0019\t\u0004G.DeB\u00013j\u001d\t)\u0007.D\u0001g\u0015\t9'%\u0001\u0004=e>|GOP\u0005\u0002O%\u0011!NJ\u0001\ba\u0006\u001c7.Y4f\u0013\taWN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tQg%A\u0003dY\u0016\f'\u000fF\u0001Y\u0003Y\tG\u000e\\%oG2,H-\u001b8h\u001dVdGNV1mk\u0016\u001cX#\u0001:\u0011\u0007\r\u001c\b*\u0003\u0002u[\n\u00191+Z9)\u000551\bCA<{\u001b\u0005A(BA=\u001f\u0003\u0011)H/\u001b7\n\u0005mD(!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u0006A1\r\\8tK\u0006cG.\u0001\u0005jg\u000ecwn]3e+\u0005\u0019\u0016AD3ogV\u0014XmQ1qC\u000eLG/_\u0001\u000fG>l\u0007/\u001e;f\u001d\u0016<8+\u001b>f)\ry\u0013Q\u0001\u0005\u0007\u0003\u000f\t\u0002\u0019A\u0018\u0002\u000f=dGmU5{K\"\u0012\u0011C^\u0001\u001b'&tw\r\\3UQJ,\u0017\rZ3e%\u0016\u001cx.\u001e:dKB{w\u000e\u001c\t\u0003WM\u0019\"a\u0005\u0013\u0015\u0005\u00055\u0011\u0001D*I\u00032cujV0T\u0013j+U#A(\u0002\u001bMC\u0015\t\u0014'P/~\u001b\u0016JW#!\u0001")
public class SingleThreadedResourcePool
implements ResourcePool {
    private final ResourceMonitor monitor;
    private final MemoryTracker memoryTracker;
    public int org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark;
    public AutoCloseablePlus[] org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables;
    private long trackedSize;
    private boolean _isClosed;

    @Override
    public String toString() {
        return ResourcePool.toString$(this);
    }

    @Override
    public void add(AutoCloseablePlus resource) {
        int i = resource.getToken();
        if (i == -1) {
            this.ensureCapacity();
            this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark] = resource;
            resource.setToken(this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark);
            ++this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark;
            return;
        }
        if (this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i] != resource) {
            throw new IllegalStateException(resource + " does not match " + this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i]);
        }
    }

    @Override
    public boolean remove(AutoCloseablePlus resource) {
        int i = resource.getToken();
        if (i < this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark && i != -1) {
            if (this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i] != resource) {
                throw new IllegalStateException(resource + " does not match " + this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i]);
            }
            resource.setToken(-1);
            this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i] = null;
            if (i == this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark - 1) {
                int j;
                for (j = i; j >= 0 && this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[j] == null; --j) {
                }
                this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark -= i - j;
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AutoCloseablePlus> all() {
        return new Iterator<AutoCloseablePlus>(this){
            private int offset;
            private final /* synthetic */ SingleThreadedResourcePool $outer;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<AutoCloseablePlus> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<AutoCloseablePlus> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<AutoCloseablePlus> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> partition(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, AutoCloseablePlus, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<AutoCloseablePlus, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<AutoCloseablePlus, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<AutoCloseablePlus> filter(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> filterNot(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> filterImpl(Function1<AutoCloseablePlus, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<AutoCloseablePlus> withFilter(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<AutoCloseablePlus, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<AutoCloseablePlus> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<AutoCloseablePlus> distinctBy(Function1<AutoCloseablePlus, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<AutoCloseablePlus, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<AutoCloseablePlus, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<AutoCloseablePlus, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<AutoCloseablePlus> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<AutoCloseablePlus> takeWhile(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<AutoCloseablePlus> dropWhile(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> span(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<AutoCloseablePlus> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<AutoCloseablePlus, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<AutoCloseablePlus, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<AutoCloseablePlus> tapEach(Function1<AutoCloseablePlus, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<AutoCloseablePlus> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<AutoCloseablePlus, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<AutoCloseablePlus> find(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, AutoCloseablePlus, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<AutoCloseablePlus, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, AutoCloseablePlus, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<AutoCloseablePlus, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, AutoCloseablePlus, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<AutoCloseablePlus, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, AutoCloseablePlus, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<AutoCloseablePlus, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<AutoCloseablePlus> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<AutoCloseablePlus> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<AutoCloseablePlus> maxByOption(Function1<AutoCloseablePlus, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<AutoCloseablePlus> minByOption(Function1<AutoCloseablePlus, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<AutoCloseablePlus, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, AutoCloseablePlus, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<AutoCloseablePlus, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<AutoCloseablePlus, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<AutoCloseablePlus> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<AutoCloseablePlus> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<AutoCloseablePlus> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V$> Map<K$, V$> toMap(.less.colon.less<AutoCloseablePlus, Tuple2<K$, V$>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<AutoCloseablePlus> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<AutoCloseablePlus> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<AutoCloseablePlus> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<AutoCloseablePlus> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<AutoCloseablePlus, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private int offset() {
                return this.offset;
            }

            private void offset_$eq(int x$1) {
                this.offset = x$1;
            }

            public boolean hasNext() {
                while (this.offset() < this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark && this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[this.offset()] == null) {
                    this.offset_$eq(this.offset() + 1);
                }
                return this.offset() < this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark;
            }

            public AutoCloseablePlus next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException();
                }
                AutoCloseablePlus closeable = this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[this.offset()];
                this.offset_$eq(this.offset() + 1);
                return closeable;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.offset = 0;
            }
        };
    }

    private void clear() {
        this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark = 0;
    }

    @VisibleForTesting
    public Seq<AutoCloseablePlus> allIncludingNullValues() {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables));
    }

    @Override
    public void closeAll() {
        if (!this._isClosed) {
            Throwable error = null;
            for (int i = 0; i < this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark; ++i) {
                try {
                    AutoCloseablePlus resource = this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i];
                    if (resource == null) continue;
                    this.monitor.close(resource);
                    resource.setToken(-1);
                    resource.setCloseListener(null);
                    resource.close();
                    continue;
                }
                catch (Throwable t) {
                    error = Exceptions.chain(error, (Throwable)t);
                }
            }
            if (error != null) {
                throw error;
            }
            this.clear();
            this.memoryTracker.releaseHeap(this.trackedSize + SingleThreadedResourcePool$.MODULE$.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$SHALLOW_SIZE());
            this._isClosed = true;
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    private void ensureCapacity() {
        if (this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables.length <= this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark) {
            AutoCloseablePlus[] temp = this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables;
            long oldHeapUsage = this.trackedSize;
            int newSize = this.computeNewSize(this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables.length);
            this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)newSize);
            this.memoryTracker.allocateHeap(this.trackedSize);
            this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables = new AutoCloseablePlus[newSize];
            System.arraycopy(temp, 0, this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables, 0, temp.length);
            this.memoryTracker.releaseHeap(oldHeapUsage);
            return;
        }
    }

    @VisibleForTesting
    public int computeNewSize(int oldSize) {
        int minSize = oldSize + 1;
        if (minSize < 0) {
            return Integer.MAX_VALUE;
        }
        int newSize = oldSize * 2;
        if (newSize < 0) {
            return minSize;
        }
        return newSize;
    }

    public SingleThreadedResourcePool(int capacity, ResourceMonitor monitor, MemoryTracker memoryTracker) {
        this.monitor = monitor;
        this.memoryTracker = memoryTracker;
        ResourcePool.$init$(this);
        this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark = 0;
        this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables = new AutoCloseablePlus[capacity];
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)capacity);
        this._isClosed = false;
        memoryTracker.allocateHeap(SingleThreadedResourcePool$.MODULE$.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$SHALLOW_SIZE() + this.trackedSize);
    }
}

