/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.ResourcePool;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.lang.AutoCloseablePlus;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e3AAC\u0006\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\re\u0002\u0001\u0015!\u0003,\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015\t\u0005\u0001\"\u0011C\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u00159\u0006\u0001\"\u0011Y\u0005Y!\u0006N]3bIN\u000bg-\u001a*fg>,(oY3Q_>d'B\u0001\u0007\u000e\u0003\u001d\u0011XO\u001c;j[\u0016T!AD\b\u0002\u0011%tG/\u001a:oC2T!\u0001E\t\u0002\r\rL\b\u000f[3s\u0015\t\u00112#A\u0003oK>$$NC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"A\u0006\n\u0005\u0001Z!\u0001\u0004*fg>,(oY3Q_>d\u0017aB7p]&$xN\u001d\t\u0003=\rJ!\u0001J\u0006\u0003\u001fI+7o\\;sG\u0016luN\\5u_J\fa\u0001P5oSRtDCA\u0014)!\tq\u0002\u0001C\u0003\"\u0005\u0001\u0007!%A\u0005sKN|WO]2fgV\t1\u0006E\u0002-cMj\u0011!\f\u0006\u0003]=\nA!\u001e;jY*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0003i]j\u0011!\u000e\u0006\u0003mE\tA\u0001\\1oO&\u0011\u0001(\u000e\u0002\u0012\u0003V$xn\u00117pg\u0016\f'\r\\3QYV\u001c\u0018A\u0003:fg>,(oY3tA\u0005\u0019\u0011\r\u001a3\u0015\u0005qz\u0004C\u0001\r>\u0013\tq\u0014D\u0001\u0003V]&$\b\"\u0002!\u0006\u0001\u0004\u0019\u0014\u0001\u0003:fg>,(oY3\u0002\rI,Wn\u001c<f)\t\u0019e\t\u0005\u0002\u0019\t&\u0011Q)\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001e\u00011\u00014\u0003\r\tG\u000e\u001c\u000b\u0002\u0013B\u0019!JU\u001a\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(\u0016\u0003\u0019a$o\\8u}%\t!$\u0003\u0002R3\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005!IE/\u001a:bi>\u0014(BA)\u001a\u0003!\u0019Gn\\:f\u00032dG#\u0001\u001f\u0002\u0011%\u001c8\t\\8tK\u0012,\u0012a\u0011")
public class ThreadSafeResourcePool
implements ResourcePool {
    private final ResourceMonitor monitor;
    private final Collection<AutoCloseablePlus> resources;

    @Override
    public String toString() {
        return ResourcePool.toString$(this);
    }

    public Collection<AutoCloseablePlus> resources() {
        return this.resources;
    }

    @Override
    public void add(AutoCloseablePlus resource) {
        this.resources().add(resource);
    }

    @Override
    public boolean remove(AutoCloseablePlus resource) {
        return this.resources().remove(resource);
    }

    @Override
    public Iterator<AutoCloseablePlus> all() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.resources().iterator()).asScala();
    }

    @Override
    public void closeAll() {
        java.util.Iterator<AutoCloseablePlus> iterator = this.resources().iterator();
        Throwable error = null;
        while (iterator.hasNext()) {
            try {
                AutoCloseablePlus resource = iterator.next();
                this.monitor.close(resource);
                resource.setCloseListener(null);
                resource.close();
            }
            catch (Throwable t) {
                error = Exceptions.chain(error, (Throwable)t);
            }
        }
        if (error != null) {
            throw error;
        }
        this.resources().clear();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public ThreadSafeResourcePool(ResourceMonitor monitor) {
        this.monitor = monitor;
        ResourcePool.$init$(this);
        this.resources = new ConcurrentLinkedQueue<AutoCloseablePlus>();
    }
}

