/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CursorUtils {
    private CursorUtils() {
        throw new UnsupportedOperationException();
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        assert (node >= -1L);
        return CursorUtils.nodeGetProperty(read, nodeCursor, node, propertyCursor, prop, true);
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (node >= -1L);
        if (node == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            if (throwOnDeleted && read.nodeDeletedInTransaction(node)) {
                throw EntityNotFoundException.nodeDeletedInThisTransaction((long)node);
            }
            return Values.NO_VALUE;
        }
        return CursorUtils.nodeGetProperty(nodeCursor, propertyCursor, prop);
    }

    public static Value nodeGetProperty(NodeCursor nodeCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        nodeCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static Value[] entityGetProperties(EntityCursor entityCursor, PropertyCursor propertyCursor, int[] tokens) {
        assert (entityCursor.reference() != -1L);
        Value[] values = CursorUtils.emptyPropertyArray(tokens.length);
        entityCursor.properties(propertyCursor, PropertySelection.selection((int[])tokens));
        while (propertyCursor.next()) {
            int index = ArrayUtils.indexOf((int[])tokens, (int)propertyCursor.propertyKey());
            values[index] = propertyCursor.propertyValue();
        }
        return values;
    }

    public static Value[] emptyPropertyArray(int len) {
        Object[] values = new Value[len];
        Arrays.fill(values, Values.NO_VALUE);
        return values;
    }

    public static boolean nodeHasProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasProperty(nodeCursor, propertyCursor, prop);
    }

    public static boolean nodeHasProperty(NodeCursor nodeCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return false;
        }
        nodeCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static boolean nodeHasLabel(Read read, NodeCursor nodeCursor, long node, int label) {
        if (label == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel(label);
    }

    public static boolean nodeHasLabels(Read read, NodeCursor nodeCursor, long node, int[] labels) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasLabels(nodeCursor, labels);
    }

    public static boolean nodeHasLabels(NodeCursor nodeCursor, int[] labels) {
        for (int label : labels) {
            if (label == -1) {
                return false;
            }
            if (nodeCursor.hasLabel(label)) continue;
            return false;
        }
        return true;
    }

    public static boolean nodeHasALabel(Read read, NodeCursor nodeCursor, long node) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel();
    }

    public static boolean nodeHasALabel(NodeCursor nodeCursor) {
        return nodeCursor.hasLabel();
    }

    public static boolean nodeHasAnyLabel(Read read, NodeCursor nodeCursor, long node, int[] labels) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasAnyLabel(nodeCursor, labels);
    }

    public static boolean nodeHasAnyLabel(NodeCursor cursor, int[] labels) {
        TokenSet nodeLabels = cursor.labels();
        for (int label : labels) {
            if (!nodeLabels.contains(label)) continue;
            return true;
        }
        return false;
    }

    public static boolean relationshipHasType(Read read, RelationshipScanCursor relationshipCursor, long relationship, int type) {
        if (type == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        return relationshipCursor.type() == type;
    }

    public static boolean relationshipHasTypes(Read read, RelationshipScanCursor relationshipCursor, long relationship, int[] types) {
        assert (types.length > 0);
        int typeToLookFor = types[0];
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == typeToLookFor) continue;
            return false;
        }
        if (typeToLookFor == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        return relationshipCursor.type() == typeToLookFor;
    }

    public static boolean relationshipHasTypes(Read read, RelationshipScanCursor relationshipCursor, VirtualRelationshipValue relationship, int[] types) {
        assert (types.length > 0);
        int typeToLookFor = types[0];
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == typeToLookFor) continue;
            return false;
        }
        if (typeToLookFor == -1) {
            return false;
        }
        return new VirtualRelationshipReader(read, relationshipCursor, relationship, true).hasType(typeToLookFor);
    }

    public static boolean relationshipHasTypes(RelationshipScanCursor relationshipCursor, int[] types) {
        assert (types.length > 0);
        int typeToLookFor = types[0];
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == typeToLookFor) continue;
            return false;
        }
        if (typeToLookFor == -1) {
            return false;
        }
        return relationshipCursor.type() == typeToLookFor;
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        return CursorUtils.relationshipGetProperty(read, relationshipCursor, relationship, propertyCursor, prop, true);
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (relationship >= -1L);
        if (relationship == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            if (throwOnDeleted && read.relationshipDeletedInTransaction(relationship)) {
                throw EntityNotFoundException.relationshipDeletedInThisTransaction((long)relationship);
            }
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, VirtualRelationshipValue relationship, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (relationship.id() >= -1L);
        if (relationship.id() == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        return new VirtualRelationshipReader(read, relationshipCursor, relationship, throwOnDeleted).property(propertyCursor, prop);
    }

    public static Value relationshipGetProperty(RelationshipCursor relationshipCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static boolean relationshipHasProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static boolean relationshipHasProperty(Read read, RelationshipScanCursor relationshipCursor, VirtualRelationshipValue relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        return new VirtualRelationshipReader(read, relationshipCursor, relationship, true).hasProperty(propertyCursor, prop);
    }

    public static boolean relationshipHasProperty(RelationshipCursor relationshipCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return false;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static int[] relationshipPropertyIds(Read read, VirtualRelationshipValue relationship, RelationshipScanCursor cursor, PropertyCursor propertyCursor) {
        return new VirtualRelationshipReader(read, cursor, relationship).propertyIds(propertyCursor);
    }

    public static MapValue relationshipAsMap(Read read, TokenRead tokenRead, VirtualRelationshipValue relationship, RelationshipScanCursor cursor, PropertyCursor propertyCursor, MapValueBuilder seenProperties, IntSet seenPropertyTokens) throws PropertyKeyIdNotFoundKernelException {
        return new VirtualRelationshipReader(read, cursor, relationship).asMap(tokenRead, propertyCursor, seenProperties, seenPropertyTokens);
    }

    public static AnyValue propertyGet(String key, AnyValue container, Read read, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        RelationshipValue rel;
        NodeValue node;
        if (container == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof NodeValue && (node = (NodeValue)container).id() < 0L) {
            return node.properties().get(key);
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node2 = (VirtualNodeValue)container;
            return CursorUtils.nodeGetProperty(read, nodeCursor, node2.id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof RelationshipValue && (rel = (RelationshipValue)container).id() < 0L) {
            return rel.properties().get(key);
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel2 = (VirtualRelationshipValue)container;
            return CursorUtils.relationshipGetProperty(read, relationshipScanCursor, rel2, propertyCursor, dbAccess.propertyKey(key), true);
        }
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return map.get(key);
        }
        if (container instanceof TemporalValue) {
            TemporalValue temporal = (TemporalValue)container;
            return temporal.get(key);
        }
        if (container instanceof DurationValue) {
            DurationValue duration = (DurationValue)container;
            return duration.get(key);
        }
        if (container instanceof PointValue) {
            PointValue point = (PointValue)container;
            return point.get(key);
        }
        throw CypherTypeException.expectedMap((String)String.valueOf(container), (String)container.prettyPrint(), (String)CypherTypeValueMapper.valueType(container));
    }

    public static AnyValue[] propertiesGet(String[] keys, AnyValue container, Read read, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        RelationshipValue rel;
        NodeValue node;
        if (container == Values.NO_VALUE) {
            return CursorUtils.emptyPropertyArray(keys.length);
        }
        if (container instanceof NodeValue && (node = (NodeValue)container).id() < 0L) {
            AnyValue[] values = new AnyValue[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                MapValue nodeProps = node.properties();
                values[i] = nodeProps.containsKey(keys[i]) ? nodeProps.get(keys[i]) : Values.NO_VALUE;
            }
            return values;
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node2 = (VirtualNodeValue)container;
            return CursorUtils.propertiesGet(CursorUtils.propertyKeys(keys, dbAccess), node2.id(), read, nodeCursor, propertyCursor);
        }
        if (container instanceof RelationshipValue && (rel = (RelationshipValue)container).id() < 0L) {
            AnyValue[] values = new AnyValue[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                MapValue nodeProps = rel.properties();
                values[i] = nodeProps.containsKey(keys[i]) ? nodeProps.get(keys[i]) : Values.NO_VALUE;
            }
            return values;
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel2 = (VirtualRelationshipValue)container;
            return CursorUtils.propertiesGet(CursorUtils.propertyKeys(keys, dbAccess), rel2, read, relationshipScanCursor, propertyCursor);
        }
        return CursorUtils.propertiesGet(keys, container);
    }

    public static AnyValue[] propertiesGet(String[] keys, AnyValue container) {
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return CursorUtils.propertiesGet(keys, map);
        }
        if (container instanceof TemporalValue) {
            TemporalValue temporal = (TemporalValue)container;
            return CursorUtils.propertiesGet(keys, temporal);
        }
        if (container instanceof DurationValue) {
            DurationValue duration = (DurationValue)container;
            return CursorUtils.propertiesGet(keys, duration);
        }
        if (container instanceof PointValue) {
            PointValue point = (PointValue)container;
            return CursorUtils.propertiesGet(keys, point);
        }
        throw CypherTypeException.expectedMap((String)String.valueOf(container), (String)container.prettyPrint(), (String)CypherTypeValueMapper.valueType(container));
    }

    public static Value[] propertiesGet(int[] keys, long node, Read read, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        read.singleNode(node, nodeCursor);
        if (nodeCursor.next()) {
            return CursorUtils.entityGetProperties((EntityCursor)nodeCursor, propertyCursor, keys);
        }
        if (read.nodeDeletedInTransaction(node)) {
            throw EntityNotFoundException.nodeDeletedInThisTransaction((long)node);
        }
        return CursorUtils.emptyPropertyArray(keys.length);
    }

    public static Value[] propertiesGet(int[] keys, long rel, Read read, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        read.singleRelationship(rel, relCursor);
        if (relCursor.next()) {
            return CursorUtils.entityGetProperties((EntityCursor)relCursor, propertyCursor, keys);
        }
        if (read.relationshipDeletedInTransaction(rel)) {
            throw EntityNotFoundException.relationshipDeletedInThisTransaction((long)rel);
        }
        return CursorUtils.emptyPropertyArray(keys.length);
    }

    public static Value[] propertiesGet(int[] keys, VirtualRelationshipValue rel, Read read, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        return new VirtualRelationshipReader(read, relCursor, rel, true).properties(keys, propertyCursor);
    }

    public static int[] propertyKeys(String[] keys, DbAccess dbAccess) {
        int[] tokens = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            tokens[i] = dbAccess.propertyKey(keys[i]);
        }
        return tokens;
    }

    public static AnyValue[] propertiesGet(String[] keys, MapValue map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static AnyValue[] propertiesGet(String[] keys, TemporalValue<?, ?> map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static AnyValue[] propertiesGet(String[] keys, DurationValue map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static AnyValue[] propertiesGet(String[] keys, PointValue map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static VirtualRelationshipValue relationshipById(RelationshipCursor cursor) {
        return VirtualValues.relationship((long)cursor.relationshipReference(), (long)cursor.sourceNodeReference(), (long)cursor.targetNodeReference(), (int)cursor.type());
    }

    static final class VirtualRelationshipReader
    implements Consumer<RelationshipVisitor> {
        private final Read read;
        private final RelationshipScanCursor cursor;
        private final VirtualRelationshipValue relationship;
        private final boolean throwOnDeleted;
        private boolean isSet;

        VirtualRelationshipReader(Read read, RelationshipScanCursor cursor, VirtualRelationshipValue relationship) {
            this(read, cursor, relationship, true);
        }

        VirtualRelationshipReader(Read read, RelationshipScanCursor cursor, VirtualRelationshipValue relationship, boolean throwOnDeleted) {
            this.read = read;
            this.cursor = cursor;
            this.relationship = relationship;
            this.throwOnDeleted = throwOnDeleted;
            this.isSet = false;
        }

        @Override
        public void accept(RelationshipVisitor relationshipVisitor) {
            this.read.singleRelationship(this.relationship.id(), this.cursor);
            if (this.cursor.next()) {
                relationshipVisitor.visit(this.cursor.sourceNodeReference(), this.cursor.targetNodeReference(), this.cursor.type());
                this.isSet = true;
            }
        }

        private boolean next() {
            long start = this.relationship.startNodeId((Consumer)this);
            long end = this.relationship.endNodeId((Consumer)this);
            int type = this.relationship.relationshipTypeId((Consumer)this);
            if (!this.isSet) {
                this.read.singleRelationship(this.relationship.id(), start, type, end, this.cursor);
                if (!this.cursor.next()) {
                    if (this.throwOnDeleted && this.read.relationshipDeletedInTransaction(this.relationship.id())) {
                        throw EntityNotFoundException.relationshipDeletedInThisTransaction((long)this.relationship.id());
                    }
                    return false;
                }
            }
            return true;
        }

        public Value property(PropertyCursor propertyCursor, int prop) {
            if (this.next()) {
                this.cursor.properties(propertyCursor, PropertySelection.selection((int)prop));
                return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
            }
            return Values.NO_VALUE;
        }

        public Value[] properties(int[] keys, PropertyCursor propertyCursor) {
            if (this.next()) {
                return CursorUtils.entityGetProperties((EntityCursor)this.cursor, propertyCursor, keys);
            }
            return CursorUtils.emptyPropertyArray(keys.length);
        }

        public boolean hasProperty(PropertyCursor propertyCursor, int prop) {
            if (this.next()) {
                this.cursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
                return propertyCursor.next();
            }
            return false;
        }

        public boolean hasType(int typeToLookFor) {
            if (this.next()) {
                return this.cursor.type() == typeToLookFor;
            }
            return false;
        }

        public int[] propertyIds(PropertyCursor propertyCursor) {
            if (this.next()) {
                IntArrayList res = new IntArrayList();
                this.cursor.properties(propertyCursor);
                while (propertyCursor.next()) {
                    res.add(propertyCursor.propertyKey());
                }
                return res.toArray();
            }
            return ArrayUtils.EMPTY_INT_ARRAY;
        }

        public MapValue asMap(TokenRead tokenRead, PropertyCursor propertyCursor, MapValueBuilder builder, IntSet seenTokens) throws PropertyKeyIdNotFoundKernelException {
            if (this.next()) {
                this.cursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES.excluding(arg_0 -> ((IntSet)seenTokens).contains(arg_0)));
                while (propertyCursor.next()) {
                    builder.add(tokenRead.propertyKeyName(propertyCursor.propertyKey()), (AnyValue)propertyCursor.propertyValue());
                }
                return builder.build();
            }
            return VirtualValues.EMPTY_MAP;
        }
    }
}

