/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Iterator;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class TargetTracker
implements AutoCloseable {
    private int unsaturatedTargets = 0;
    private final HeapTrackingArrayList<NodeState> targets;
    private final PPBFSHooks hooks;

    public TargetTracker(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.targets = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
        this.hooks = hooks;
    }

    public void incrementUnsaturatedCount() {
        ++this.unsaturatedTargets;
    }

    public void decrementUnsaturatedCount() {
        --this.unsaturatedTargets;
        Preconditions.checkState((this.unsaturatedTargets >= 0 ? 1 : 0) != 0, (String)"Unsaturated target count should never be negative");
    }

    public boolean allKnownTargetsSaturated() {
        return this.unsaturatedTargets == 0;
    }

    public void addTarget(NodeState nodeState) {
        Preconditions.checkArgument((boolean)nodeState.isTarget(), (String)"Node must be a target");
        assert (!this.targets.contains((Object)nodeState)) : "Caller is responsible for adding any node as a target at most once per level";
        this.targets.add((Object)nodeState);
        this.hooks.addTarget(nodeState);
    }

    public boolean hasCurrentUnsaturatedTargets() {
        for (NodeState t : this.targets) {
            if (t.isSaturated()) continue;
            return true;
        }
        return false;
    }

    public Iterator<NodeState> iterate() {
        return this.targets.iterator();
    }

    public boolean hasTargets() {
        return this.targets.notEmpty();
    }

    public void clear() {
        this.targets.clear();
    }

    @Override
    public void close() throws Exception {
        this.targets.close();
    }
}

