/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.shortestloop;

import java.util.Iterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedShortestLoopCursor;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

public final class ZeroLengthShortestCursor
extends UndirectedShortestLoopCursor
implements ShortestPathBFS {
    private final PathReference pathReference;
    private boolean hasNext;

    public ZeroLengthShortestCursor(long startNode) {
        long[] nodes = new long[1];
        long[] relationships = new long[]{};
        nodes[0] = startNode;
        this.hasNext = true;
        this.pathReference = VirtualValues.pathReference((long[])nodes, (long[])relationships);
    }

    @Override
    public boolean next() {
        if (!this.hasNext) {
            return false;
        }
        this.hasNext = false;
        return true;
    }

    @Override
    public PathReference path() {
        if (this.hasNext) {
            return this.pathReference;
        }
        return null;
    }

    @Override
    public Iterator<PathReference> shortestPathIterator() {
        return Iterators.iterator((Object)this.pathReference);
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
    }
}

