/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs;

import java.net.URI;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.neo4j.genai.dbs.ProviderResolver;
import org.neo4j.genai.dbs.VectorDatabaseProvider;

public final class DefaultProviderResolver
implements ProviderResolver {
    private static final Predicate<String> PATTERN_PINECONE = Pattern.compile(".+\\.pinecone\\.io").asMatchPredicate();
    private static final Predicate<String> PATTERN_WEAVIATE = Pattern.compile(".+\\.weaviate\\.cloud").asMatchPredicate();
    private static final Predicate<String> QDRANT = Pattern.compile(".+\\.qdrant\\.io").asMatchPredicate();

    @Override
    public Optional<VectorDatabaseProvider> resolve(String url) {
        return this.getProviderName(url).map(KNOWN_PROVIDERS::get);
    }

    Optional<String> getProviderName(String url) {
        URI uri = URI.create(url);
        String host = uri.getHost();
        if (host == null) {
            host = url;
        }
        if (PATTERN_PINECONE.test(host)) {
            return Optional.of("pinecone");
        }
        if (PATTERN_WEAVIATE.test(host)) {
            return Optional.of("weaviate");
        }
        if (QDRANT.test(host)) {
            return Optional.of("qdrant");
        }
        return Optional.empty();
    }
}

